/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.tuples;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.tuples.Tuple2;
import io.smallrye.mutiny.tuples.Tuple3;
import io.smallrye.mutiny.tuples.Tuple4;
import io.smallrye.mutiny.tuples.Tuple5;
import java.util.List;

public abstract class Tuples {
    private Tuples() {
    }

    public static <L, R> Tuple2<L, R> tuple2(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 2) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 2 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple2.of(list.get(0), list.get(1));
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> tuple3(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 3) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 3 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple3.of(list.get(0), list.get(1), list.get(2));
    }

    public static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> tuple4(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 4) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 4 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple4.of(list.get(0), list.get(1), list.get(2), list.get(3));
    }

    public static <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> tuple5(List<?> list) {
        if (ParameterValidation.nonNull(list, "list").size() != 5) {
            throw new IllegalArgumentException("Cannot create a tuple from the given list, size must be 5 (actual size is " + ParameterValidation.nonNull(list, "list").size() + ")");
        }
        return Tuple5.of(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4));
    }

    public static void ensureArity(List<?> parameters, int expectedSize) {
        if (parameters.size() != expectedSize) {
            throw new IllegalArgumentException("Cannot call combinator from list. Expected size: " + expectedSize + ", Actual size: " + parameters.size());
        }
    }
}

