/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

abstract class AbstractSharedContext
implements InjectableContext,
InjectableContext.ContextState {
    private final ComputingCache<Key<?>, ContextInstanceHandle<?>> instances = new ComputingCache<Key, ContextInstanceHandle>(AbstractSharedContext::createInstanceHandle);

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        return this.instances.getValue(new Key<T>(contextual, creationalContext)).get();
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        ContextInstanceHandle<?> handle = this.instances.getValueIfPresent(new Key<T>(contextual, null));
        return handle != null ? (T)handle.get() : null;
    }

    @Override
    public InjectableContext.ContextState getState() {
        return this;
    }

    @Override
    public Map<InjectableBean<?>, Object> getContextualInstances() {
        return this.instances.getPresentValues().stream().collect(Collectors.toMap(InstanceHandle::getBean, InstanceHandle::get));
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        ContextInstanceHandle<?> handle = this.instances.remove(new Key(contextual, null));
        if (handle != null) {
            handle.destroy();
        }
    }

    @Override
    public synchronized void destroy() {
        Set<ContextInstanceHandle<?>> values = this.instances.getPresentValues();
        Iterator<ContextInstanceHandle<?>> iterator = values.iterator();
        while (iterator.hasNext()) {
            ContextInstanceHandle<?> instanceHandle = iterator.next();
            if (instanceHandle.getBean().getDeclaringBean() == null) continue;
            instanceHandle.destroy();
            iterator.remove();
        }
        for (ContextInstanceHandle<?> instanceHandle : values) {
            instanceHandle.destroy();
        }
        this.instances.clear();
    }

    private static ContextInstanceHandle createInstanceHandle(Key key) {
        InjectableBean bean = (InjectableBean)key.contextual;
        return new ContextInstanceHandleImpl(bean, bean.create(key.creationalContext), key.creationalContext);
    }

    private static final class Key<T> {
        private final Contextual<T> contextual;
        private final CreationalContext<T> creationalContext;

        Key(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            this.contextual = Objects.requireNonNull(contextual);
            this.creationalContext = creationalContext;
        }

        public int hashCode() {
            return this.contextual.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.contextual.equals(other.contextual);
        }

        public String toString() {
            return "Key for " + this.contextual;
        }
    }
}

