/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import com.oracle.svm.core.annotate.AlwaysInline;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.wildfly.common.lock.SpinLock;

final class LoggerNode {
    private static final Object[] NO_ATTACHMENTS = new Object[0];
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private final ConcurrentMap<String, LoggerNode> children;
    private volatile Handler[] handlers;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private volatile boolean useParentFilter = false;
    private static final AtomicArray<LoggerNode, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(LoggerNode.class, Handler[].class, "handlers"), Handler.class);
    private volatile Level level;
    private volatile int effectiveLevel;
    private final int effectiveMinLevel;
    private volatile boolean hasLogger;
    private final SpinLock attachmentLock = new SpinLock();
    private Logger.AttachmentKey<?> attachmentKey;
    private Object attachment;

    LoggerNode(LogContext context) {
        EmbeddedConfigurator configurator = LogContext.CONFIGURATOR;
        this.parent = null;
        this.fullName = "";
        Level minLevel = configurator.getMinimumLevelOf(this.fullName);
        this.effectiveMinLevel = minLevel == null ? Logger.INFO_INT : minLevel.intValue();
        Level confLevel = configurator.getLevelOf(this.fullName);
        this.level = confLevel == null ? Level.INFO : confLevel;
        this.effectiveLevel = Math.max(this.effectiveMinLevel, this.level.intValue());
        handlersUpdater.set(this, (Handler[])configurator.getHandlersOf(this.fullName));
        this.context = context;
        this.children = new CopyOnWriteMap<String, LoggerNode>();
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        EmbeddedConfigurator configurator = LogContext.CONFIGURATOR;
        nodeName = nodeName.trim();
        if (nodeName.length() == 0 && parent == null) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace and has no parent");
        }
        this.parent = parent;
        this.fullName = parent.parent == null ? (nodeName.isEmpty() ? "." : nodeName) : parent.fullName + "." + nodeName;
        Level minLevel = configurator.getMinimumLevelOf(this.fullName);
        this.effectiveMinLevel = minLevel == null ? parent.effectiveMinLevel : minLevel.intValue();
        this.level = configurator.getLevelOf(this.fullName);
        this.effectiveLevel = Math.max(this.effectiveMinLevel, this.level == null ? parent.effectiveLevel : this.level.intValue());
        handlersUpdater.set(this, (Handler[])configurator.getHandlersOf(this.fullName));
        this.context = context;
        this.children = new CopyOnWriteMap<String, LoggerNode>();
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    LoggerNode getIfExists(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null) {
            return null;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getIfExists(name.substring(i + 1));
    }

    Logger createLogger() {
        this.hasLogger = true;
        return new Logger(this, this.fullName);
    }

    Collection<LoggerNode> getChildren() {
        return this.children.values();
    }

    LogContext getContext() {
        return this.context;
    }

    void setEffectiveLevel(int newLevel) {
        if (this.level == null) {
            this.effectiveLevel = newLevel;
            for (LoggerNode node : this.children.values()) {
                if (node == null) continue;
                node.setEffectiveLevel(newLevel);
            }
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    Filter getFilter() {
        return this.filter;
    }

    boolean getUseParentFilters() {
        return this.useParentFilter;
    }

    void setUseParentFilters(boolean useParentFilter) {
        this.useParentFilter = useParentFilter;
    }

    @AlwaysInline(value="Fast level checks")
    int getEffectiveLevel() {
        return this.effectiveLevel;
    }

    @AlwaysInline(value="Fast level checks")
    boolean isLoggableLevel(int level) {
        return level != Logger.OFF_INT && level >= this.effectiveMinLevel && level >= this.effectiveLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler[] getHandlers() {
        Handler[] handlers = this.handlers;
        if (handlers == null) {
            LoggerNode loggerNode = this;
            synchronized (loggerNode) {
                handlers = LogContext.CONFIGURATOR.getHandlersOf(this.fullName);
                this.handlers = handlers;
            }
        }
        return handlers;
    }

    Handler[] clearHandlers() {
        Handler[] handlers = this.handlers;
        handlersUpdater.set(this, (Handler[])EmbeddedConfigurator.NO_HANDLERS);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    void removeHandler(Handler handler) {
        handlersUpdater.remove(this, handler, true);
    }

    void addHandler(Handler handler) {
        handlersUpdater.add(this, handler);
    }

    Handler[] setHandlers(Handler[] handlers) {
        return handlersUpdater.getAndSet(this, (Handler[])handlers);
    }

    boolean compareAndSetHandlers(Handler[] oldHandlers, Handler[] newHandlers) {
        return handlersUpdater.compareAndSet(this, (Handler[])oldHandlers, (Handler[])newHandlers);
    }

    boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
    }

    void publish(ExtLogRecord record) {
        LoggerNode parent;
        for (Handler handler : this.getHandlers()) {
            try {
                handler.publish(record);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.useParentHandlers && (parent = this.parent) != null) {
            parent.publish(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLevel(Level newLevel) {
        Object lock;
        LogContext context = this.context;
        Object object = lock = context.treeLock;
        synchronized (object) {
            int newEffectiveLevel;
            int oldEffectiveLevel = this.effectiveLevel;
            if (newLevel != null) {
                this.level = newLevel;
                newEffectiveLevel = newLevel.intValue();
            } else {
                LoggerNode parent = this.parent;
                if (parent == null) {
                    this.level = Level.INFO;
                    newEffectiveLevel = Logger.INFO_INT;
                } else {
                    this.level = null;
                    newEffectiveLevel = parent.effectiveLevel;
                }
            }
            this.effectiveLevel = newEffectiveLevel;
            if (oldEffectiveLevel != newEffectiveLevel) {
                for (LoggerNode node : this.children.values()) {
                    if (node == null) continue;
                    node.setEffectiveLevel(newEffectiveLevel);
                }
            }
        }
    }

    Level getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V getAttachment(Logger.AttachmentKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            Object object = key == this.attachmentKey ? this.attachment : null;
            return (V)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V attach(Logger.AttachmentKey<V> key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            Logger.AttachmentKey<?> attachmentKey = this.attachmentKey;
            if (attachmentKey == null) {
                this.attachmentKey = key;
                this.attachment = value;
                V v = null;
                return v;
            }
            if (key == attachmentKey) {
                Object object;
                try {
                    object = this.attachment;
                    this.attachment = value;
                }
                catch (Throwable throwable) {
                    this.attachment = value;
                    throw throwable;
                }
                return (V)object;
            }
        }
        finally {
            lock.unlock();
        }
        throw new IllegalStateException("Maximum number of attachments exceeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            Logger.AttachmentKey<?> attachmentKey = this.attachmentKey;
            if (attachmentKey == null) {
                this.attachmentKey = key;
                this.attachment = value;
                V v = null;
                return v;
            }
            if (key == attachmentKey) {
                Object object = this.attachment;
                return (V)object;
            }
        }
        finally {
            lock.unlock();
        }
        throw new IllegalStateException("Maximum number of attachments exceeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V detach(Logger.AttachmentKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        Logger.AttachmentKey<?> attachmentKey = this.attachmentKey;
        if (attachmentKey == key) {
            Object object = this.attachment;
            return (V)object;
            finally {
                this.attachmentKey = null;
                this.attachment = null;
            }
        }
        V v = null;
        return v;
        finally {
            lock.unlock();
        }
    }

    LoggerNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLoggable(ExtLogRecord record) {
        Object lock;
        if (!this.useParentFilter) {
            Filter filter = this.filter;
            return filter == null || filter.isLoggable(record);
        }
        LogContext context = this.context;
        Object object = lock = context.treeLock;
        synchronized (object) {
            return LoggerNode.isLoggable(this, record);
        }
    }

    private static boolean isLoggable(LoggerNode loggerNode, ExtLogRecord record) {
        if (loggerNode == null) {
            return true;
        }
        Filter filter = loggerNode.filter;
        return !(filter != null && !filter.isLoggable(record) || loggerNode.useParentFilter && !LoggerNode.isLoggable(loggerNode.getParent(), record));
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public String getFullName() {
        return this.fullName;
    }
}

