/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class UniOnItemConsume<T>
extends UniOperator<T, T> {
    private final Consumer<? super T> onItemCallback;
    private final Consumer<Throwable> onFailureCallback;
    private final Predicate<? super Throwable> onFailurePredicate;

    public UniOnItemConsume(Uni<? extends T> upstream, Consumer<? super T> onItemCallback, Consumer<Throwable> onFailureCallback, Predicate<? super Throwable> predicate) {
        super(upstream);
        this.onItemCallback = onItemCallback;
        this.onFailureCallback = onFailureCallback;
        this.onFailurePredicate = predicate;
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super T> subscriber) {
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<T, T>(subscriber){

            @Override
            public void onItem(T item) {
                if (UniOnItemConsume.this.invokeEventHandler(UniOnItemConsume.this.onItemCallback, item, false, subscriber)) {
                    subscriber.onItem(item);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                block7: {
                    if (UniOnItemConsume.this.onFailurePredicate != null) {
                        try {
                            if (UniOnItemConsume.this.onFailurePredicate.test(failure)) {
                                if (UniOnItemConsume.this.invokeEventHandler(UniOnItemConsume.this.onFailureCallback, failure, true, subscriber)) {
                                    subscriber.onFailure(failure);
                                }
                                break block7;
                            }
                            subscriber.onFailure(failure);
                        }
                        catch (Throwable e) {
                            subscriber.onFailure(new CompositeException(failure, e));
                        }
                    } else if (UniOnItemConsume.this.invokeEventHandler(UniOnItemConsume.this.onFailureCallback, failure, true, subscriber)) {
                        subscriber.onFailure(failure);
                    }
                }
            }
        });
    }

    private <E> boolean invokeEventHandler(Consumer<? super E> handler, E event, boolean wasCalledByOnFailure, UniSerializedSubscriber<? super T> subscriber) {
        if (handler != null) {
            try {
                handler.accept(event);
            }
            catch (Throwable e) {
                if (wasCalledByOnFailure) {
                    subscriber.onFailure(new CompositeException((Throwable)event, e));
                } else {
                    subscriber.onFailure(e);
                }
                return false;
            }
        }
        return true;
    }
}

