/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.IfSectionHelper;
import io.quarkus.qute.IncludeSectionHelper;
import io.quarkus.qute.InsertSectionHelper;
import io.quarkus.qute.LoopSectionHelper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SetSectionHelper;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.WithSectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class EngineBuilder {
    private final Map<String, SectionHelperFactory<?>> sectionHelperFactories = new HashMap();
    private final List<ValueResolver> valueResolvers = new ArrayList<ValueResolver>();
    private final List<NamespaceResolver> namespaceResolvers = new ArrayList<NamespaceResolver>();
    private final List<TemplateLocator> locators = new ArrayList<TemplateLocator>();
    private final List<ResultMapper> resultMappers = new ArrayList<ResultMapper>();
    private Function<String, SectionHelperFactory<?>> sectionHelperFunc;

    EngineBuilder() {
    }

    public EngineBuilder addSectionHelper(SectionHelperFactory<?> factory) {
        for (String alias : factory.getDefaultAliases()) {
            this.sectionHelperFactories.put(alias, factory);
        }
        return this;
    }

    public EngineBuilder addSectionHelpers(SectionHelperFactory<?> ... factories) {
        for (SectionHelperFactory<?> factory : factories) {
            this.addSectionHelper(factory);
        }
        return this;
    }

    public EngineBuilder addSectionHelper(String name, SectionHelperFactory<?> factory) {
        this.addSectionHelper(factory);
        this.sectionHelperFactories.put(name, factory);
        return this;
    }

    public EngineBuilder addDefaultSectionHelpers() {
        return this.addSectionHelpers(new IfSectionHelper.Factory(), new LoopSectionHelper.Factory(), new WithSectionHelper.Factory(), new IncludeSectionHelper.Factory(), new InsertSectionHelper.Factory(), new SetSectionHelper.Factory());
    }

    public EngineBuilder addValueResolver(Supplier<ValueResolver> resolverSupplier) {
        return this.addValueResolver(resolverSupplier.get());
    }

    public EngineBuilder addValueResolvers(ValueResolver ... resolvers) {
        for (ValueResolver valueResolver : resolvers) {
            this.addValueResolver(valueResolver);
        }
        return this;
    }

    public EngineBuilder addValueResolver(ValueResolver resolver) {
        this.valueResolvers.add(resolver);
        return this;
    }

    public EngineBuilder addDefaultValueResolvers() {
        return this.addValueResolvers(ValueResolvers.mapResolver(), ValueResolvers.mapperResolver(), ValueResolvers.mapEntryResolver(), ValueResolvers.collectionResolver(), ValueResolvers.thisResolver(), ValueResolvers.orResolver(), ValueResolvers.trueResolver());
    }

    public EngineBuilder addDefaults() {
        return this.addDefaultSectionHelpers().addDefaultValueResolvers();
    }

    public EngineBuilder addNamespaceResolver(NamespaceResolver resolver) {
        for (NamespaceResolver namespaceResolver : this.namespaceResolvers) {
            if (!namespaceResolver.getNamespace().equals(resolver.getNamespace())) continue;
            throw new IllegalArgumentException(String.format("Namespace %s is already handled by %s", resolver.getNamespace()));
        }
        this.namespaceResolvers.add(resolver);
        return this;
    }

    public EngineBuilder addLocator(TemplateLocator locator) {
        this.locators.add(locator);
        return this;
    }

    public EngineBuilder addResultMapper(ResultMapper mapper) {
        this.resultMappers.add(mapper);
        return this;
    }

    public EngineBuilder computeSectionHelper(Function<String, SectionHelperFactory<?>> func) {
        this.sectionHelperFunc = func;
        return this;
    }

    public Engine build() {
        return new EngineImpl(this.sectionHelperFactories, this.valueResolvers, this.namespaceResolvers, this.locators, this.resultMappers, this.sectionHelperFunc);
    }
}

