/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateImpl;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.TextNode;
import io.quarkus.qute.Variant;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class Parser
implements Function<String, Expression> {
    private static final Logger LOGGER = Logger.getLogger(Parser.class);
    private static final String ROOT_HELPER_NAME = "$root";
    static final TemplateNode.Origin SYNTHETIC_ORIGIN = new OriginImpl(0, 0, "<<synthetic>>", "<<synthetic>>", Optional.empty());
    private final EngineImpl engine;
    private static final char START_DELIMITER = '{';
    private static final char END_DELIMITER = '}';
    private static final char COMMENT_DELIMITER = '!';
    private static final char UNDERSCORE = '_';
    private static final char ESCAPE_CHAR = '\\';
    private static final char LINE_SEPARATOR_LF = '\n';
    private static final char LINE_SEPARATOR_CR = '\r';
    static final char START_COMPOSITE_PARAM = '(';
    static final char END_COMPOSITE_PARAM = ')';
    private StringBuilder buffer;
    private State state;
    private int line;
    private int lineCharacter;
    private final Deque<SectionNode.Builder> sectionStack;
    private final Deque<SectionBlock.Builder> sectionBlockStack;
    private final Deque<SectionHelperFactory.ParametersInfo> paramsStack;
    private final Deque<Map<String, String>> typeInfoStack;
    private int sectionBlockIdx;
    private boolean ignoreContent;
    private String id;
    private String generatedId;
    private Optional<Variant> variant;

    public Parser(EngineImpl engine) {
        this.engine = engine;
        this.state = State.TEXT;
        this.buffer = new StringBuilder();
        this.sectionStack = new ArrayDeque<SectionNode.Builder>();
        this.sectionStack.addFirst(SectionNode.builder(ROOT_HELPER_NAME, this.origin()).setEngine(engine).setHelperFactory(new SectionHelperFactory<SectionHelper>(){

            @Override
            public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
                return new SectionHelper(){

                    @Override
                    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
                        return context.execute();
                    }
                };
            }
        }));
        this.sectionBlockStack = new ArrayDeque<SectionBlock.Builder>();
        this.sectionBlockStack.addFirst(SectionBlock.builder("$main", this, this::parserError));
        this.sectionBlockIdx = 0;
        this.paramsStack = new ArrayDeque<SectionHelperFactory.ParametersInfo>();
        this.paramsStack.addFirst(SectionHelperFactory.ParametersInfo.EMPTY);
        this.typeInfoStack = new ArrayDeque<Map<String, String>>();
        this.typeInfoStack.addFirst(new HashMap());
        this.line = 1;
        this.lineCharacter = 1;
    }

    Template parse(Reader reader, Optional<Variant> variant, String id, String generatedId) {
        long start = System.currentTimeMillis();
        this.id = id;
        this.generatedId = generatedId;
        this.variant = variant;
        try {
            SectionNode.Builder root;
            int val;
            while ((val = reader.read()) != -1) {
                this.processCharacter((char)val);
            }
            if (this.buffer.length() > 0) {
                if (this.state == State.TEXT) {
                    this.flushText();
                } else {
                    throw this.parserError("unexpected non-text buffer at the end of the template - probably an unterminated tag: " + this.buffer);
                }
            }
            if ((root = this.sectionStack.peek()) == null) {
                throw this.parserError("no root section found");
            }
            if (!root.helperName.equals(ROOT_HELPER_NAME)) {
                throw this.parserError("unterminated section [" + root.helperName + "] detected");
            }
            SectionBlock.Builder part = this.sectionBlockStack.peek();
            if (part == null) {
                throw this.parserError("no root section part found");
            }
            root.addBlock(part.build());
            TemplateImpl template = new TemplateImpl(this.engine, root.build(), generatedId, variant);
            LOGGER.tracef("Parsing finished in %s ms", System.currentTimeMillis() - start);
            return template;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private void processCharacter(char character) {
        switch (this.state) {
            case TEXT: {
                this.text(character);
                break;
            }
            case ESCAPE: {
                this.escape(character);
                break;
            }
            case TAG_INSIDE: {
                this.tag(character);
                break;
            }
            case COMMENT: {
                this.comment(character);
                break;
            }
            case TAG_CANDIDATE: {
                this.tagCandidate(character);
                break;
            }
            default: {
                throw this.parserError("unknown parsing state: " + (Object)((Object)this.state));
            }
        }
        ++this.lineCharacter;
    }

    private void escape(char character) {
        if (character != '{' && character != '}') {
            this.buffer.append('\\');
        }
        this.buffer.append(character);
        this.state = State.TEXT;
    }

    private void text(char character) {
        if (character == '{') {
            this.state = State.TAG_CANDIDATE;
        } else if (character == '\\') {
            this.state = State.ESCAPE;
        } else {
            if (this.isLineSeparator(character)) {
                ++this.line;
                this.lineCharacter = 1;
            }
            this.buffer.append(character);
        }
    }

    private void comment(char character) {
        if (character == '}' && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == '!') {
            this.state = State.TEXT;
            this.buffer = new StringBuilder();
        } else {
            this.buffer.append(character);
        }
    }

    private void tag(char character) {
        if (character == '}') {
            this.flushTag();
        } else {
            this.buffer.append(character);
        }
    }

    private void tagCandidate(char character) {
        if (this.isValidIdentifierStart(character)) {
            this.flushText();
            this.state = character == '!' ? State.COMMENT : State.TAG_INSIDE;
            this.buffer.append(character);
        } else {
            this.buffer.append('{').append(character);
            if (this.isLineSeparator(character)) {
                ++this.line;
                this.lineCharacter = 1;
            }
            this.state = State.TEXT;
        }
    }

    private boolean isValidIdentifierStart(char character) {
        return Tag.isCommand(character) || character == '!' || character == '_' || Character.isDigit(character) || Character.isAlphabetic(character);
    }

    private boolean isLineSeparator(char character) {
        return character == '\r' || character == '\n' && (this.buffer.length() == 0 || this.buffer.charAt(this.buffer.length() - 1) != '\r');
    }

    private void flushText() {
        if (this.buffer.length() > 0 && !this.ignoreContent) {
            SectionBlock.Builder block = this.sectionBlockStack.peek();
            block.addNode(new TextNode(this.buffer.toString(), this.origin()));
        }
        this.buffer = new StringBuilder();
    }

    private void flushTag() {
        this.state = State.TEXT;
        String content = this.buffer.toString().trim();
        String tag = '{' + content + '}';
        if (content.charAt(0) == Tag.SECTION.command.charValue()) {
            Iterator<String> iter;
            boolean isEmptySection = false;
            if (content.charAt(content.length() - 1) == Tag.SECTION_END.command.charValue()) {
                content = content.substring(0, content.length() - 1);
                isEmptySection = true;
            }
            if (!(iter = Parser.splitSectionParams(content, this::parserError)).hasNext()) {
                throw this.parserError("no helper name declared");
            }
            String sectionName = iter.next();
            sectionName = sectionName.substring(1, sectionName.length());
            SectionNode.Builder lastSection = this.sectionStack.peek();
            if (lastSection != null && lastSection.factory.getBlockLabels().contains(sectionName) || lastSection.factory.treatUnknownSectionsAsBlocks() && !this.engine.getSectionHelperFactories().containsKey(sectionName)) {
                if (!this.ignoreContent) {
                    this.sectionStack.peek().addBlock(this.sectionBlockStack.pop().build());
                }
                SectionBlock.Builder block = SectionBlock.builder("" + this.sectionBlockIdx++, this, this::parserError).setOrigin(this.origin());
                this.sectionBlockStack.addFirst(block.setLabel(sectionName));
                this.processParams(tag, sectionName, iter);
                Map<String, String> typeInfos = this.typeInfoStack.peek();
                Map<String, String> result = this.sectionStack.peek().factory.initializeBlock(typeInfos, block);
                if (!result.isEmpty()) {
                    HashMap<String, String> newTypeInfos = new HashMap<String, String>();
                    newTypeInfos.putAll(typeInfos);
                    newTypeInfos.putAll(result);
                    this.typeInfoStack.addFirst(newTypeInfos);
                } else {
                    this.typeInfoStack.addFirst(typeInfos);
                }
                this.ignoreContent = false;
            } else {
                SectionHelperFactory<?> factory = this.engine.getSectionHelperFactory(sectionName);
                if (factory == null) {
                    throw this.parserError("no section helper found for " + tag);
                }
                this.paramsStack.addFirst(factory.getParameters());
                SectionBlock.Builder mainBlock = SectionBlock.builder("$main", this, this::parserError).setOrigin(this.origin());
                this.sectionBlockStack.addFirst(mainBlock);
                this.processParams(tag, "$main", iter);
                Map<String, String> typeInfos = this.typeInfoStack.peek();
                Map<String, String> result = factory.initializeBlock(typeInfos, mainBlock);
                SectionNode.Builder sectionNode = SectionNode.builder(sectionName, this.origin()).setEngine(this.engine).setHelperFactory(factory);
                if (isEmptySection) {
                    sectionNode.addBlock(mainBlock.build());
                    this.paramsStack.pop();
                    this.sectionBlockStack.pop();
                    this.sectionBlockStack.peek().addNode(sectionNode.build());
                } else {
                    if (!result.isEmpty()) {
                        HashMap<String, String> newTypeInfos = new HashMap<String, String>();
                        newTypeInfos.putAll(typeInfos);
                        newTypeInfos.putAll(result);
                        this.typeInfoStack.addFirst(newTypeInfos);
                    } else {
                        this.typeInfoStack.addFirst(typeInfos);
                    }
                    this.sectionStack.addFirst(sectionNode);
                }
            }
        } else if (content.charAt(0) == Tag.SECTION_END.command.charValue()) {
            SectionBlock.Builder block = this.sectionBlockStack.peek();
            SectionNode.Builder section = this.sectionStack.peek();
            String name = content.substring(1, content.length());
            if (block != null && !block.getLabel().equals("$main") && !section.helperName.equals(name)) {
                if (!name.isEmpty() && !block.getLabel().equals(name)) {
                    throw this.parserError("section block end tag [" + name + "] does not match the start tag [" + block.getLabel() + "]");
                }
                section.addBlock(this.sectionBlockStack.pop().build());
                this.ignoreContent = true;
            } else {
                if (!name.isEmpty() && !section.helperName.equals(name)) {
                    throw this.parserError("section end tag [" + name + "] does not match the start tag [" + section.helperName + "]");
                }
                section = this.sectionStack.pop();
                if (!this.ignoreContent) {
                    section.addBlock(this.sectionBlockStack.pop().build());
                } else {
                    this.ignoreContent = false;
                }
                this.sectionBlockStack.peek().addNode(section.build());
            }
            this.typeInfoStack.pop();
        } else if (content.charAt(0) == Tag.PARAM.command.charValue()) {
            Map<String, String> typeInfos = this.typeInfoStack.peek();
            int spaceIdx = content.indexOf(" ");
            String key = content.substring(spaceIdx + 1, content.length());
            String value = content.substring(1, spaceIdx);
            typeInfos.put(key, '|' + value + '|');
        } else {
            this.sectionBlockStack.peek().addNode(new ExpressionNode(this.apply(content), this.engine, this.origin()));
        }
        this.buffer = new StringBuilder();
    }

    private TemplateException parserError(String message) {
        StringBuilder builder = new StringBuilder("Parser error");
        if (!this.id.equals(this.generatedId)) {
            builder.append(" in template [").append(this.id).append("]");
        }
        builder.append(" on line ").append(this.line).append(": ").append(message);
        return new TemplateException(this.origin(), builder.toString());
    }

    private void processParams(String tag, String label, Iterator<String> iter) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        List<Parameter> factoryParams = this.paramsStack.peek().get(label);
        ArrayList<String> paramValues = new ArrayList<String>();
        while (iter.hasNext()) {
            paramValues.add(iter.next());
        }
        if (paramValues.size() > factoryParams.size()) {
            LOGGER.debugf("Too many params [label=%s, params=%s, factoryParams=%s]", (Object)label, (Object)paramValues, (Object)factoryParams);
        }
        if (paramValues.size() < factoryParams.size()) {
            block1: for (String param : paramValues) {
                int equalsPosition = Parser.getFirstDeterminingEqualsCharPosition(param);
                if (equalsPosition != -1) {
                    params.put(param.substring(0, equalsPosition), param.substring(equalsPosition + 1, param.length()));
                    continue;
                }
                for (Parameter factoryParam : factoryParams) {
                    if (factoryParam.defaultValue != null || params.containsKey(factoryParam.name)) continue;
                    params.put(factoryParam.name, param);
                    continue block1;
                }
            }
        } else {
            int generatedIdx = 0;
            for (String param : paramValues) {
                int equalsPosition = Parser.getFirstDeterminingEqualsCharPosition(param);
                if (equalsPosition != -1) {
                    params.put(param.substring(0, equalsPosition), param.substring(equalsPosition + 1, param.length()));
                    continue;
                }
                Parameter found = null;
                for (Parameter factoryParam : factoryParams) {
                    if (params.containsKey(factoryParam.name)) continue;
                    found = factoryParam;
                    params.put(factoryParam.name, param);
                    break;
                }
                if (found != null) continue;
                params.put("" + generatedIdx++, param);
            }
        }
        factoryParams.stream().filter(p -> p.defaultValue != null).forEach(p -> params.putIfAbsent(p.name, p.defaultValue));
        List undeclaredParams = factoryParams.stream().filter(p -> !p.optional && !params.containsKey(p.name)).collect(Collectors.toList());
        if (!undeclaredParams.isEmpty()) {
            throw this.parserError("mandatory section parameters not declared for " + tag + ": " + undeclaredParams);
        }
        params.forEach(this.sectionBlockStack.peek()::addParameter);
    }

    static int getFirstDeterminingEqualsCharPosition(String part) {
        boolean stringLiteral = false;
        for (int i = 0; i < part.length(); ++i) {
            if (Parser.isStringLiteralSeparator(part.charAt(i))) {
                if (i == 0) {
                    return -1;
                }
                stringLiteral = !stringLiteral;
                continue;
            }
            if (stringLiteral || part.charAt(i) != '=' || i == 0 || i >= part.length() - 1) continue;
            return i;
        }
        return -1;
    }

    static Iterator<String> splitSectionParams(String content, Function<String, RuntimeException> errorFun) {
        boolean stringLiteral = false;
        int composite = 0;
        boolean space = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == ' ') {
                if (space) continue;
                if (!stringLiteral && composite == 0) {
                    if (buffer.length() > 0) {
                        parts.add(buffer.toString());
                        buffer = new StringBuilder();
                    }
                    space = true;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (composite == 0 && Parser.isStringLiteralSeparator(c)) {
                stringLiteral = !stringLiteral;
            } else if (!stringLiteral && Parser.isCompositeStart(c) && (i == 0 || space || composite > 0 || buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '!')) {
                composite = (short)(composite + 1);
            } else if (!stringLiteral && Parser.isCompositeEnd(c) && composite > 0) {
                composite = (short)(composite - 1);
            }
            space = false;
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            if (stringLiteral || composite > 0) {
                throw errorFun.apply("unterminated string literal or composite parameter detected for [" + content + "]");
            }
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    static boolean isCompositeStart(char character) {
        return character == '(';
    }

    static boolean isCompositeEnd(char character) {
        return character == ')';
    }

    static ExpressionImpl parseExpression(String value, Map<String, String> typeInfos, TemplateNode.Origin origin) {
        List<String> strParts;
        if (value == null || value.isEmpty()) {
            return ExpressionImpl.EMPTY;
        }
        if (typeInfos == null) {
            typeInfos = Collections.emptyMap();
        }
        String namespace = null;
        int namespaceIdx = value.indexOf(58);
        int spaceIdx = value.indexOf(32);
        int bracketIdx = value.indexOf(40);
        if (!(namespaceIdx == -1 || spaceIdx != -1 && namespaceIdx >= spaceIdx || bracketIdx != -1 && namespaceIdx >= bracketIdx)) {
            strParts = Expressions.splitParts(value.substring(namespaceIdx + 1, value.length()));
            namespace = value.substring(0, namespaceIdx);
        } else {
            String literal;
            Object literalValue;
            strParts = Expressions.splitParts(value);
            if (strParts.size() == 1 && !Results.Result.NOT_FOUND.equals(literalValue = LiteralSupport.getLiteralValue(literal = strParts.get(0)))) {
                return ExpressionImpl.literal(literal, literalValue, origin);
            }
        }
        ArrayList<Expression.Part> parts = new ArrayList<Expression.Part>(strParts.size());
        Expression.Part first = null;
        for (String strPart : strParts) {
            Expression.Part part = Parser.createPart(namespace, first, strPart, typeInfos, origin);
            if (first == null) {
                first = part;
            }
            parts.add(part);
        }
        return new ExpressionImpl(namespace, parts, (Object)Results.Result.NOT_FOUND, origin);
    }

    private static Expression.Part createPart(String namespace, Expression.Part first, String value, Map<String, String> typeInfos, TemplateNode.Origin origin) {
        if (Expressions.isVirtualMethod(value)) {
            String name = Expressions.parseVirtualMethodName(value);
            ArrayList<String> strParams = new ArrayList<String>(Expressions.parseVirtualMethodParams(value));
            ArrayList<Expression> params = new ArrayList<Expression>(strParams.size());
            for (String strParam : strParams) {
                params.add(Parser.parseExpression(strParam.trim(), typeInfos, origin));
            }
            return new ExpressionImpl.VirtualMethodExpressionPartImpl(name, params);
        }
        String typeInfo = null;
        if (namespace != null) {
            typeInfo = value;
        } else if (first == null) {
            typeInfo = typeInfos.get(value);
        } else if (first.getTypeInfo() != null) {
            typeInfo = value;
        }
        return new ExpressionImpl.ExpressionPartImpl(value, typeInfo);
    }

    static boolean isSeparator(char candidate) {
        return candidate == '.' || candidate == '[' || candidate == ']';
    }

    static boolean isStringLiteralSeparator(char character) {
        return character == '\"' || character == '\'';
    }

    static boolean isLeftBracket(char character) {
        return character == '(';
    }

    static boolean isRightBracket(char character) {
        return character == ')';
    }

    @Override
    public ExpressionImpl apply(String value) {
        return Parser.parseExpression(value, this.typeInfoStack.peek(), this.origin());
    }

    TemplateNode.Origin origin() {
        return new OriginImpl(this.line, this.lineCharacter, this.id, this.generatedId, this.variant);
    }

    static class OriginImpl
    implements TemplateNode.Origin {
        private final int line;
        private final int lineCharacter;
        private final String templateId;
        private final String templateGeneratedId;
        private final Optional<Variant> variant;

        OriginImpl(int line, int lineCharacter, String templateId, String templateGeneratedId, Optional<Variant> variant) {
            this.line = line;
            this.lineCharacter = lineCharacter;
            this.templateId = templateId;
            this.templateGeneratedId = templateGeneratedId;
            this.variant = variant;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getLineCharacter() {
            return this.lineCharacter;
        }

        @Override
        public String getTemplateId() {
            return this.templateId;
        }

        @Override
        public String getTemplateGeneratedId() {
            return this.templateGeneratedId;
        }

        @Override
        public Optional<Variant> getVariant() {
            return this.variant;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.templateGeneratedId, this.templateId, this.variant);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OriginImpl other = (OriginImpl)obj;
            return this.line == other.line && Objects.equals(this.templateGeneratedId, other.templateGeneratedId) && Objects.equals(this.templateId, other.templateId) && Objects.equals(this.variant, other.variant);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Template ").append(this.templateId).append(" at line ").append(this.line);
            return builder.toString();
        }
    }

    static enum State {
        TEXT,
        TAG_INSIDE,
        TAG_CANDIDATE,
        COMMENT,
        ESCAPE;

    }

    static enum Tag {
        EXPRESSION(null),
        SECTION(Character.valueOf('#')),
        SECTION_END(Character.valueOf('/')),
        PARAM(Character.valueOf('@'));

        final Character command;

        private Tag(Character command) {
            this.command = command;
        }

        static boolean isCommand(char command) {
            for (Tag tag : Tag.values()) {
                if (tag.command == null || tag.command.charValue() != command) continue;
                return true;
            }
            return false;
        }
    }
}

