/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import com.oracle.svm.core.OS;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.graal.DiagnosticPrinter;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.CDI;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.wildfly.common.lock.Locks;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ApplicationLifecycleManager {
    private static volatile Consumer<Integer> defaultExitCodeHandler = new Consumer<Integer>(){

        @Override
        public void accept(Integer integer) {
            System.exit(integer);
        }
    };
    private static final String DISABLE_SIGNAL_HANDLERS = "DISABLE_SIGNAL_HANDLERS";
    private static final Lock stateLock = Locks.reentrantLock();
    private static final Condition stateCond = stateLock.newCondition();
    private static int exitCode = -1;
    private static boolean shutdownRequested;
    private static Application currentApplication;
    private static boolean hooksRegistered;
    private static boolean vmShuttingDown;

    private ApplicationLifecycleManager() {
    }

    public static final void run(Application application, String ... args) {
        ApplicationLifecycleManager.run(application, null, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void run(Application application, Class<? extends QuarkusApplication> quarkusApplication, Consumer<Integer> exitCodeHandler, String ... args) {
        boolean alreadyStarted;
        block29: {
            stateLock.lock();
            alreadyStarted = application.isStarted();
            if (!hooksRegistered) {
                ApplicationLifecycleManager.registerHooks();
                hooksRegistered = true;
            }
            if (currentApplication != null && !shutdownRequested) {
                throw new IllegalStateException("Quarkus already running");
            }
            try {
                exitCode = -1;
                shutdownRequested = false;
                currentApplication = application;
            }
            finally {
                stateLock.unlock();
            }
            try {
                application.start(args);
                if (quarkusApplication != null) {
                    QuarkusApplication instance;
                    Set<Bean<?>> beans = CDI.current().getBeanManager().getBeans(quarkusApplication, new Any.Literal());
                    Bean<?> bean = null;
                    for (Bean<?> i : beans) {
                        if (i.getBeanClass() != quarkusApplication) continue;
                        bean = i;
                        break;
                    }
                    if (bean == null) {
                        instance = quarkusApplication.newInstance();
                    } else {
                        CreationalContext ctx = CDI.current().getBeanManager().createCreationalContext(bean);
                        instance = (QuarkusApplication)CDI.current().getBeanManager().getReference(bean, quarkusApplication, ctx);
                    }
                    int result = -1;
                    try {
                        result = instance.run(args);
                        break block29;
                    }
                    finally {
                        stateLock.lock();
                        try {
                            if (exitCode == -1 && result != -1) {
                                exitCode = result;
                            }
                            shutdownRequested = true;
                            stateCond.signalAll();
                        }
                        finally {
                            stateLock.unlock();
                        }
                    }
                }
                stateLock.lock();
                try {
                    while (!shutdownRequested) {
                        Thread.interrupted();
                        stateCond.await();
                    }
                }
                finally {
                    stateLock.unlock();
                }
            }
            catch (Exception e) {
                Logger.getLogger(Application.class).error((Object)"Error running Quarkus application", e);
                stateLock.lock();
                try {
                    shutdownRequested = true;
                    stateCond.signalAll();
                }
                finally {
                    stateLock.unlock();
                }
                application.stop();
                (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(1);
                return;
            }
        }
        if (!alreadyStarted) {
            application.stop();
        }
        (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(ApplicationLifecycleManager.getExitCode());
    }

    private static void registerHooks() {
        if (ImageInfo.inImageRuntimeCode() && System.getenv(DISABLE_SIGNAL_HANDLERS) == null) {
            ApplicationLifecycleManager.registerSignalHandlers();
        }
        ShutdownHookThread shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
    }

    private static void registerSignalHandlers() {
        SignalHandler handler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                System.exit(signal.getNumber() + 128);
            }
        };
        SignalHandler quitHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                DiagnosticPrinter.printDiagnostics(System.out);
            }
        };
        ApplicationLifecycleManager.handleSignal("INT", handler);
        ApplicationLifecycleManager.handleSignal("TERM", handler);
        if (OS.getCurrent() == OS.WINDOWS) {
            ApplicationLifecycleManager.handleSignal("BREAK", quitHandler);
        } else {
            ApplicationLifecycleManager.handleSignal("HUP", handler);
            ApplicationLifecycleManager.handleSignal("QUIT", quitHandler);
        }
    }

    public static int getExitCode() {
        return exitCode == -1 ? 0 : exitCode;
    }

    public static void exit() {
        ApplicationLifecycleManager.exit(-1);
    }

    public static Consumer<Integer> getDefaultExitCodeHandler() {
        return defaultExitCodeHandler;
    }

    public static boolean isVmShuttingDown() {
        return vmShuttingDown;
    }

    public static void setDefaultExitCodeHandler(Consumer<Integer> defaultExitCodeHandler) {
        Objects.requireNonNull(defaultExitCodeHandler);
        ApplicationLifecycleManager.defaultExitCodeHandler = defaultExitCodeHandler;
    }

    public static void exit(int code) {
        stateLock.lock();
        try {
            if (code >= 0 && exitCode == -1) {
                exitCode = code;
            }
            if (shutdownRequested) {
                return;
            }
            shutdownRequested = true;
            stateCond.signalAll();
        }
        finally {
            stateLock.unlock();
        }
    }

    public static void waitForExit() {
        stateLock.lock();
        try {
            while (!shutdownRequested) {
                stateCond.awaitUninterruptibly();
            }
        }
        finally {
            stateLock.unlock();
        }
    }

    private static void handleSignal(String signal, SignalHandler handler) {
        try {
            Signal.handle(new Signal(signal), handler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
            super("Shutdown thread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            stateLock.lock();
            vmShuttingDown = true;
            shutdownRequested = true;
            try {
                stateCond.signalAll();
            }
            finally {
                stateLock.unlock();
            }
            currentApplication.awaitShutdown();
            System.out.flush();
            System.err.flush();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

