/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.images;

import io.quarkus.runtime.QuarkusApplication;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.infinispan.images.ConfigGenerator;
import org.infinispan.images.IdentitiesGenerator;
import picocli.CommandLine;

public class Main
implements QuarkusApplication {
    @Inject
    ConfigGenerator configGenerator;
    @Inject
    IdentitiesGenerator identitiesGenerator;

    @Override
    public int run(String ... args) {
        return new CommandLine(new MainCommand()).execute(args);
    }

    @CommandLine.Command(name="config-generator")
    class MainCommand
    implements Callable<Integer> {
        @CommandLine.Option(names={"-c", "--config"}, description={"Yaml file used to generate Infinispan configuration"})
        File server;
        @CommandLine.Option(names={"-i", "--identities"}, description={"Yaml file used to initialize identities"})
        File identities;
        @CommandLine.Parameters(index="0", description={"The directory where the generated files will be saved"}, paramLabel="output-dir")
        File outputDir;

        MainCommand() {
        }

        @Override
        public Integer call() {
            try {
                Main.this.configGenerator.process(this.server, this.outputDir);
                Main.this.identitiesGenerator.process(this.identities, this.outputDir);
                return 0;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
                return 2;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 1;
            }
        }
    }
}

