/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.SpscLinkedArrayQueue;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiMapOp;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public class MultiCombineLatestOp<I, O>
extends MultiOperator<I, O> {
    private final Iterable<? extends Publisher<? extends I>> upstreams;
    private final Function<List<?>, ? extends O> combinator;
    private final int bufferSize;
    private final boolean delayErrors;

    public MultiCombineLatestOp(Iterable<? extends Publisher<? extends I>> upstreams, Function<List<?>, ? extends O> combinator, int bufferSize, boolean delayErrors) {
        super(null);
        this.upstreams = ParameterValidation.doesNotContainNull(upstreams, "upstreams");
        this.combinator = ParameterValidation.nonNull(combinator, "combinator");
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> downstream) {
        if (downstream == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        ArrayList publishers = new ArrayList();
        this.upstreams.forEach(publishers::add);
        if (publishers.isEmpty()) {
            Subscriptions.complete(downstream);
            return;
        }
        if (publishers.size() == 1) {
            ((Publisher)publishers.get(0)).subscribe(Infrastructure.onMultiSubscription((Publisher)publishers.get(0), new MultiMapOp.MapProcessor<Object, Object>(downstream, x -> this.combinator.apply(Collections.singletonList(x)))));
            return;
        }
        CombineLatestCoordinator coordinator = new CombineLatestCoordinator(downstream, this.combinator, publishers.size(), this.bufferSize, this.delayErrors);
        downstream.onSubscribe(coordinator);
        coordinator.subscribe(publishers);
    }

    private static final class CombineLatestInnerSubscriber<T>
    implements MultiSubscriber<T> {
        private final AtomicReference<Subscription> upstream = new AtomicReference();
        private final CombineLatestCoordinator<T, ?> parent;
        private final int index;
        private final int prefetch;
        private final int limit;
        int produced;

        CombineLatestInnerSubscriber(CombineLatestCoordinator<T, ?> parent, int index, int prefetch) {
            this.parent = parent;
            this.index = index;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.upstream.compareAndSet(null, s)) {
                s.request(this.prefetch);
            }
        }

        @Override
        public void onItem(T t) {
            this.parent.innerValue(this.index, t);
        }

        @Override
        public void onFailure(Throwable t) {
            this.parent.innerError(this.index, t);
        }

        @Override
        public void onCompletion() {
            this.parent.innerComplete(this.index);
        }

        public void cancel() {
            Subscription current = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (current != Subscriptions.CANCELLED && current != null) {
                current.cancel();
            }
        }

        void requestOneItem() {
            int p = this.produced + 1;
            if (p == this.limit) {
                this.produced = 0;
                this.upstream.get().request(p);
            } else {
                this.produced = p;
            }
        }
    }

    private static final class CombineLatestCoordinator<I, O>
    implements Subscription {
        private final MultiSubscriber<? super O> downstream;
        private final Function<List<?>, ? extends O> combinator;
        private final List<CombineLatestInnerSubscriber<I>> subscribers = new ArrayList<CombineLatestInnerSubscriber<I>>();
        private final SpscLinkedArrayQueue<Object> queue;
        private final Object[] latest;
        private final boolean delayErrors;
        private int nonEmptySources;
        private int completedSources;
        private volatile boolean cancelled;
        private volatile boolean done;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicReference<Throwable> failure = new AtomicReference();
        private final AtomicInteger wip = new AtomicInteger();

        CombineLatestCoordinator(MultiSubscriber<? super O> downstream, Function<List<?>, ? extends O> combinator, int size, int bufferSize, boolean delayErrors) {
            this.downstream = downstream;
            this.combinator = combinator;
            for (int i = 0; i < size; ++i) {
                this.subscribers.add(new CombineLatestInnerSubscriber(this, i, bufferSize));
            }
            this.latest = new Object[size];
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayErrors = delayErrors;
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.cancelAll();
        }

        private void subscribe(List<Publisher<? extends I>> sources) {
            int i = 0;
            for (CombineLatestInnerSubscriber<I> subscriber : this.subscribers) {
                if (this.done || this.cancelled) {
                    return;
                }
                sources.get(i).subscribe(Infrastructure.onMultiSubscription(sources.get(i), subscriber));
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerValue(int index, I value) {
            boolean replenishInsteadOfDrain;
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os = this.latest;
                int localNonEmptySources = this.nonEmptySources;
                if (os[index] == null) {
                    this.nonEmptySources = ++localNonEmptySources;
                }
                os[index] = value;
                if (os.length == localNonEmptySources) {
                    this.queue.offer(this.subscribers.get(index), os.clone());
                    replenishInsteadOfDrain = false;
                } else {
                    replenishInsteadOfDrain = true;
                }
            }
            if (replenishInsteadOfDrain) {
                this.subscribers.get(index).requestOneItem();
            } else {
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void innerComplete(int index) {
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os = this.latest;
                if (os[index] != null) {
                    int localCompletedSources = this.completedSources + 1;
                    if (localCompletedSources != os.length) {
                        this.completedSources = localCompletedSources;
                        return;
                    }
                    this.done = true;
                } else {
                    this.done = true;
                }
            }
            this.drain();
        }

        void innerError(int index, Throwable e) {
            if (Subscriptions.addFailure(this.failure, e)) {
                if (!this.delayErrors) {
                    this.cancelAll();
                    this.done = true;
                    this.drain();
                } else {
                    this.innerComplete(index);
                }
            }
        }

        void drainAsync() {
            SpscLinkedArrayQueue<Object> q = this.queue;
            int missed = 1;
            do {
                long emitter;
                long req = this.requested.get();
                for (emitter = 0L; emitter != req; ++emitter) {
                    O resultOfCombination;
                    boolean empty;
                    boolean d = this.done;
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (this.isEmptyOrDone(d, empty)) {
                        return;
                    }
                    if (empty) break;
                    Object[] va = (Object[])q.poll();
                    try {
                        resultOfCombination = this.combinator.apply(Arrays.asList(va));
                        if (resultOfCombination == null) {
                            throw new NullPointerException("The combinator returned `null`");
                        }
                    }
                    catch (Throwable ex) {
                        this.cancelAll();
                        Subscriptions.addFailure(this.failure, ex);
                        Subscriptions.terminateAndPropagate(this.failure, this.downstream);
                        return;
                    }
                    this.downstream.onItem(resultOfCombination);
                    ((CombineLatestInnerSubscriber)v).requestOneItem();
                }
                if (emitter == req && this.isEmptyOrDone(this.done, q.isEmpty())) {
                    return;
                }
                if (emitter == 0L || req == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-emitter);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            this.drainAsync();
        }

        boolean isEmptyOrDone(boolean d, boolean empty) {
            if (this.cancelled) {
                this.cancelAll();
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayErrors) {
                    if (empty) {
                        this.cancelAll();
                        Throwable prev = Subscriptions.terminate(this.failure);
                        if (prev != null && prev != Subscriptions.TERMINATED) {
                            this.downstream.onFailure(prev);
                        } else {
                            this.downstream.onCompletion();
                        }
                        return true;
                    }
                } else {
                    Throwable prev = Subscriptions.terminate(this.failure);
                    if (prev != null && prev != Subscriptions.TERMINATED) {
                        this.cancelAll();
                        this.queue.clear();
                        this.downstream.onFailure(prev);
                        return true;
                    }
                    if (empty) {
                        this.cancelAll();
                        this.downstream.onCompletion();
                        return true;
                    }
                }
            }
            return false;
        }

        void cancelAll() {
            for (CombineLatestInnerSubscriber<I> inner : this.subscribers) {
                inner.cancel();
            }
        }
    }
}

