/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOrCombination;
import java.util.ArrayList;
import java.util.Arrays;

public class UniOr<T> {
    private final Uni<T> upstream;

    public UniOr(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> uni(Uni<T> other) {
        return this.unis(this.upstream, other);
    }

    @SafeVarargs
    public final Uni<T> unis(Uni<T> ... other) {
        ArrayList<Uni<T>> list = new ArrayList<Uni<T>>();
        list.add(this.upstream);
        list.addAll(Arrays.asList(other));
        return Infrastructure.onUniCreation(new UniOrCombination(list));
    }
}

