/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.util.function.Supplier;

public final class SecretKeys {
    private static final ThreadLocal<Boolean> LOCKED = ThreadLocal.withInitial(() -> Boolean.TRUE);

    private SecretKeys() {
        throw new UnsupportedOperationException();
    }

    public static boolean isLocked() {
        return LOCKED.get();
    }

    public static void doUnlocked(Runnable runnable) {
        SecretKeys.doUnlocked(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T doUnlocked(Supplier<T> supplier) {
        if (SecretKeys.isLocked()) {
            LOCKED.set(false);
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                LOCKED.set(true);
            }
        }
        return supplier.get();
    }

    public static void doLocked(Runnable runnable) {
        SecretKeys.doLocked(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T doLocked(Supplier<T> supplier) {
        if (!SecretKeys.isLocked()) {
            LOCKED.set(true);
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                LOCKED.set(false);
            }
        }
        return supplier.get();
    }
}

