/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;

public class ParameterValidation {
    public static final String SUPPLIER_PRODUCED_NULL = "The supplier returned `null`";
    public static final String MAPPER_RETURNED_NULL = "The mapper returned `null`";

    private ParameterValidation() {
    }

    public static Duration validate(Duration duration, String name) {
        ParameterValidation.nonNull(name, "name");
        if (duration == null) {
            throw new IllegalArgumentException(String.format("`%s` must not be `null`", name));
        }
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException(String.format("`%s` must be greater than zero`", name));
        }
        return duration;
    }

    public static <T> T nonNull(T instance, String name) {
        if (name == null) {
            throw new IllegalArgumentException("The parameter name must be set");
        }
        if (instance == null) {
            throw new IllegalArgumentException(String.format("`%s` must not be `null`", name));
        }
        return instance;
    }

    public static <T> T nonNullNpe(T instance, String name) {
        if (name == null) {
            throw new NullPointerException("The parameter name must be set");
        }
        if (instance == null) {
            throw new NullPointerException(String.format("`%s` must not be `null`", name));
        }
        return instance;
    }

    public static long positive(long amount, String name) {
        ParameterValidation.nonNull(name, "name");
        if (amount <= 0L) {
            throw new IllegalArgumentException(String.format("`%s` must be greater than zero`", name));
        }
        return amount;
    }

    public static int positive(int amount, String name) {
        ParameterValidation.nonNull(name, "name");
        if (amount <= 0) {
            throw new IllegalArgumentException(String.format("`%s` must be greater than zero", name));
        }
        return amount;
    }

    public static int positiveOrZero(int amount, String name) {
        ParameterValidation.nonNull(name, "name");
        if (amount < 0) {
            throw new IllegalArgumentException(String.format("`%s` must be positive", name));
        }
        return amount;
    }

    public static long positiveOrZero(long amount, String name) {
        ParameterValidation.nonNull(name, "name");
        if (amount < 0L) {
            throw new IllegalArgumentException(String.format("`%s` must be positive", name));
        }
        return amount;
    }

    public static <T extends Iterable<?>> T doesNotContainNull(T iterable, String name) {
        ParameterValidation.nonNull(name, "name");
        ParameterValidation.nonNull(iterable, name);
        iterable.forEach(m -> {
            if (m == null) {
                throw new IllegalArgumentException(String.format("`%s` contains a `null` value", name));
            }
        });
        return (T)iterable;
    }

    public static <T> T[] doesNotContainNull(T[] array, String name) {
        ParameterValidation.nonNull(name, "name");
        ParameterValidation.nonNull(array, name);
        Arrays.stream(array).forEach(m -> {
            if (m == null) {
                throw new IllegalArgumentException(String.format("`%s` contains a `null` value", name));
            }
        });
        return array;
    }

    public static <T extends Collection<?>> T size(T instance, int expectedSize, String name) {
        if (name == null) {
            throw new IllegalArgumentException("The parameter name must be set");
        }
        if (instance == null) {
            throw new IllegalArgumentException(String.format("`%s` must not be `null`", name));
        }
        if (instance.size() != expectedSize) {
            throw new IllegalArgumentException(String.format("`%s` must has size %d, but was %d", name, expectedSize, instance.size()));
        }
        return instance;
    }
}

