/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiBroadcast;
import io.smallrye.mutiny.groups.MultiCollect;
import io.smallrye.mutiny.groups.MultiConvert;
import io.smallrye.mutiny.groups.MultiCreate;
import io.smallrye.mutiny.groups.MultiCreateBy;
import io.smallrye.mutiny.groups.MultiGroup;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnEvent;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOnSubscribe;
import io.smallrye.mutiny.groups.MultiOnTerminate;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.smallrye.mutiny.groups.MultiTransform;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public interface Multi<T>
extends Publisher<T> {
    public static MultiCreate createFrom() {
        return MultiCreate.INSTANCE;
    }

    public static MultiCreateBy createBy() {
        return MultiCreateBy.INSTANCE;
    }

    public MultiSubscribe<T> subscribe();

    public MultiOnItem<T> onItem();

    @Deprecated
    default public <O> O then(Function<Multi<T>, O> stage) {
        return this.stage(stage);
    }

    default public <O> O stage(Function<Multi<T>, O> stage) {
        return ParameterValidation.nonNull(stage, "stage").apply(this);
    }

    public Uni<T> toUni();

    public MultiOnFailure<T> onFailure();

    public MultiOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    public MultiOnSubscribe<T> onSubscribe();

    public MultiOnFailure<T> onFailure(Class<? extends Throwable> var1);

    public MultiOnEvent<T> on();

    public Multi<T> cache();

    public MultiCollect<T> collectItems();

    public MultiGroup<T> groupItems();

    public Multi<T> emitOn(Executor var1);

    @Deprecated
    default public Multi<T> subscribeOn(Executor executor) {
        return this.runSubscriptionOn(executor);
    }

    public Multi<T> runSubscriptionOn(Executor var1);

    public MultiOnCompletion<T> onCompletion();

    public MultiTransform<T> transform();

    public MultiOverflow<T> onOverflow();

    public MultiBroadcast<T> broadcast();

    public MultiConvert<T> convert();

    default public Multi<T> filter(Predicate<? super T> predicate) {
        return this.transform().byFilteringItemsWith(predicate);
    }

    default public <O> Multi<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().transform(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public <O> Multi<O> flatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().transformToMultiAndMerge(mapper);
    }

    default public Multi<T> invoke(Consumer<? super T> callback) {
        return this.onItem().invoke(ParameterValidation.nonNull(callback, "callback"));
    }

    default public Multi<T> invokeUni(Function<? super T, ? extends Uni<?>> action) {
        return this.onItem().invokeUni(ParameterValidation.nonNull(action, "action"));
    }

    default public <O> Multi<O> concatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().transformToMultiAndConcatenate(mapper);
    }

    public MultiOnTerminate<T> onTermination();
}

