/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.jms.controller;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Stateful;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.infinispan.test.integration.as.jms.model.RegisteredMember;

@Stateful
public class RegistrationController {
    @PersistenceContext
    private EntityManager em;
    private RegisteredMember newMember;

    @Named
    public RegisteredMember getNewMember() {
        return this.newMember;
    }

    public void register() throws Exception {
        this.em.persist((Object)this.newMember);
        this.resetNewMember();
    }

    public int deleteAllMembers() throws Exception {
        return this.em.createQuery("DELETE FROM RegisteredMember").executeUpdate();
    }

    public RegisteredMember findById(Long id) {
        return (RegisteredMember)this.em.find(RegisteredMember.class, (Object)id);
    }

    public List<RegisteredMember> search(String name) {
        FullTextEntityManager fullTextEm = Search.getFullTextEntityManager((EntityManager)this.em);
        Query luceneQuery = fullTextEm.getSearchFactory().buildQueryBuilder().forEntity(RegisteredMember.class).get().keyword().onField("name").matching((Object)name).createQuery();
        return fullTextEm.createFullTextQuery(luceneQuery, new Class[0]).getResultList();
    }

    @PostConstruct
    public void resetNewMember() {
        this.newMember = new RegisteredMember();
    }
}

