/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.testframework;

import java.sql.SQLException;
import org.h2.tools.Server;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class H2DatabaseLifecycleManager {
    private int startedContainers = 0;
    private Server tcpServer;

    public synchronized void startDatabase(@Observes BeforeSuite event) {
        ++this.startedContainers;
        if (this.startedContainers == 1) {
            try {
                this.tcpServer = Server.createTcpServer((String[])new String[0]);
                this.tcpServer.start();
                System.out.println("H2 database started in TCP server mode");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void ignoreThreads(@Observes AfterClass event) {
        ThreadLeakChecker.ignoreThreadsContaining((String)"H2 TCP");
    }

    public synchronized void stopDatabase(@Observes AfterSuite event) {
        --this.startedContainers;
        if (this.startedContainers == 0 && this.tcpServer != null) {
            this.tcpServer.stop();
            System.out.println("H2 database was shut down");
            this.tcpServer = null;
        }
    }
}

