/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;

public class VersionTestHelper {
    private VersionTestHelper() {
    }

    public static String hibernateOrmModuleName() {
        return "org.hibernate";
    }

    public static String hibernateSearchModuleName() {
        return "org.hibernate.search.orm";
    }

    public static Asset manifestDependencies(String moduleDependencies) {
        return VersionTestHelper.manifest(VersionTestHelper.injectVariables(moduleDependencies));
    }

    private static Asset manifest(String dependencies) {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", dependencies)).exportAsString();
        return new StringAsset(manifest);
    }

    private static String injectVariables(String dependencies) {
        Properties projectCompilationProperties = new Properties();
        InputStream resourceAsStream = VersionTestHelper.class.getClassLoader().getResourceAsStream("module-versions.properties");
        try {
            projectCompilationProperties.load(resourceAsStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resourceAsStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Set<Map.Entry<Object, Object>> entrySet = projectCompilationProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            dependencies = dependencies.replace("${" + key + "}", value);
        }
        return dependencies;
    }
}

