/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.jms;

import javax.inject.Inject;
import org.infinispan.test.integration.as.VersionTestHelper;
import org.infinispan.test.integration.as.jms.DeploymentJmsMasterSlaveAndInfinispanAs2ndLevelCache;
import org.infinispan.test.integration.as.jms.SearchNewEntityJmsMasterSlave;
import org.infinispan.test.integration.as.jms.controller.StatisticsController;
import org.infinispan.test.integration.as.jms.model.RegisteredMember;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SearchNewEntityJmsMasterSlaveUsingInfinispanAs2ndCacheAndModulesIT
extends SearchNewEntityJmsMasterSlave {
    @Inject
    StatisticsController stats;

    @Test
    @InSequence(value=1005)
    @OperateOnDeployment(value="slave-1")
    public void secondLevelCacheShouldBeActive() throws Exception {
        RegisteredMember cachedMember = this.memberRegistration.getNewMember();
        cachedMember.setName("Johnny Cached");
        this.memberRegistration.register();
        this.memberRegistration.findById(cachedMember.getId());
        this.memberRegistration.findById(cachedMember.getId());
        this.memberRegistration.findById(cachedMember.getId());
        long secondLevelCacheMissCount = this.stats.getStatistics().getSecondLevelCacheMissCount();
        Assert.assertTrue((String)"Second level cache not enabled", (secondLevelCacheMissCount > 0L ? 1 : 0) != 0);
    }

    @Deployment(name="master", order=1)
    public static Archive<?> createDeploymentMaster() throws Exception {
        Archive<?> master = DeploymentJmsMasterSlaveAndInfinispanAs2ndLevelCache.createMaster("master");
        VersionTestHelper.addHibernateSearchManifestDependencies(master);
        return master;
    }

    @Deployment(name="slave-1", order=2)
    public static Archive<?> createDeploymentSlave1() throws Exception {
        Archive<?> slave = DeploymentJmsMasterSlaveAndInfinispanAs2ndLevelCache.createSlave("slave-1");
        VersionTestHelper.addHibernateSearchManifestDependencies(slave);
        return slave;
    }

    @Deployment(name="slave-2", order=3)
    public static Archive<?> createDeploymentSlave2() throws Exception {
        Archive<?> slave = DeploymentJmsMasterSlaveAndInfinispanAs2ndLevelCache.createSlave("slave-2");
        VersionTestHelper.addHibernateSearchManifestDependencies(slave);
        return slave;
    }
}

