/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.jms.infinispan;

import java.util.List;
import javax.inject.Inject;
import org.infinispan.test.integration.as.jms.controller.RegistrationController;
import org.infinispan.test.integration.as.jms.infinispan.controller.MembersCache;
import org.infinispan.test.integration.as.jms.model.RegisteredMember;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.InSequence;
import org.junit.Assert;
import org.junit.Test;

public abstract class SearchNewEntityJmsMasterSlaveAndInfinispan {
    private static final int SLEEP_TIME_FOR_SYNCHRONIZATION = 50;
    private static final int MAX_PERIOD_RETRIES = 5;
    private static final int MAX_SEARCH_ATTEMPTS = 100;
    @Inject
    RegistrationController memberRegistration;
    @Inject
    MembersCache cache;

    @Test
    @InSequence(value=0)
    @OperateOnDeployment(value="master")
    public void deleteExistingMembers() throws Exception {
        int deletedMembers = this.memberRegistration.deleteAllMembers();
        Assert.assertEquals((String)"At the start of the test there should be no members", (long)0L, (long)deletedMembers);
    }

    @Test
    @InSequence(value=1)
    @OperateOnDeployment(value="slave-1")
    public void registerNewMemberOnSlave1() throws Exception {
        RegisteredMember newMember = this.memberRegistration.getNewMember();
        Assert.assertNull((String)"A non registered member should have null ID", (Object)newMember.getId());
        newMember.setName("Davide D'Alto");
        newMember.setEmail("slave1@email");
        this.memberRegistration.register();
        Assert.assertNotNull((String)"A registered member should have an ID", (Object)newMember.getId());
        this.cache.put("slave-1", newMember.getName());
    }

    @Test
    @InSequence(value=2)
    @OperateOnDeployment(value="slave-2")
    public void registerNewMemberOnSlave2() throws Exception {
        RegisteredMember newMember = this.memberRegistration.getNewMember();
        Assert.assertNull((String)"A non registered member should have null ID", (Object)newMember.getId());
        newMember.setName("Peter O'Tall");
        newMember.setEmail("slave2@email");
        this.memberRegistration.register();
        Assert.assertNotNull((String)"A registered member should have an ID", (Object)newMember.getId());
        this.cache.put("slave-2", newMember.getName());
        Assert.assertEquals((Object)"Davide D'Alto", (Object)this.cache.get("slave-1"));
    }

    @Test
    @InSequence(value=3)
    @OperateOnDeployment(value="master")
    public void searchNewMembersAfterSynchronizationOnMaster() throws Exception {
        this.assertSearchResult("Davide D'Alto", this.search("Davide"));
        this.assertSearchResult("Peter O'Tall", this.search("Peter"));
        Assert.assertEquals((String)"Missing cache entry", (Object)"Davide D'Alto", (Object)this.cache.get("slave-1"));
        Assert.assertEquals((String)"Missing cache entry", (Object)"Peter O'Tall", (Object)this.cache.get("slave-2"));
    }

    private void assertSearchResult(String expectedResult, List<RegisteredMember> results) {
        Assert.assertEquals((String)("Unexpected number of results, expected  <" + expectedResult + ">"), (long)1L, (long)results.size());
        Assert.assertEquals((String)"Unexpected result from search", (Object)expectedResult, (Object)results.get(0).getName());
    }

    private void waitForIndexSynchronization() throws InterruptedException {
        Thread.sleep(50L);
    }

    private List<RegisteredMember> search(String name) throws InterruptedException {
        List<RegisteredMember> results = this.memberRegistration.search(name);
        for (int attempts = 0; results.size() == 0 && attempts < 100; ++attempts) {
            this.waitForIndexSynchronization();
            results = this.memberRegistration.search(name);
        }
        return results;
    }
}

