/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.wildfly;

import java.util.List;
import javax.ejb.EJBTransactionRolledbackException;
import javax.inject.Inject;
import org.apache.lucene.document.Document;
import org.infinispan.test.integration.as.wildfly.controller.MemberRegistration;
import org.infinispan.test.integration.as.wildfly.model.Member;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.InSequence;
import org.junit.Assert;
import org.junit.Test;

class MemberRegistrationBase {
    private static final double GD_LATITUDE = 37.769645;
    private static final double GD_LONGITUDE = -122.446428;
    private static final double CH_LATITUDE = 37.780392;
    private static final double CH_LONGITUDE = -122.513898;
    private static final double CBGB_LATITUDE = 40.726157;
    private static final double CBGB_LONGITUDE = -73.992116;
    private static final double KD_LATITUDE = 40.723165;
    private static final double KD_LONGITUDE = -73.987439;
    private static final double BG_LATITUDE = 41.874808;
    private static final double BG_LONGITUDE = -87.625983;
    @Inject
    MemberRegistration memberRegistration;

    MemberRegistrationBase() {
    }

    @Test
    @InSequence(value=1)
    @OperateOnDeployment(value="dep.active-1")
    public void testRegister() throws Exception {
        Member newMember = this.memberRegistration.getNewMember();
        newMember.setName("Davide D'Alto");
        newMember.setEmail("davide@mailinator.com");
        newMember.setPhoneNumber("2125551234");
        newMember.setLatitude(37.780392);
        newMember.setLongitude(-122.513898);
        this.memberRegistration.register();
        Assert.assertNotNull((Object)newMember.getId());
        Assert.assertEquals((String)"Index size isn't correct", (long)1L, (long)this.memberRegistration.indexSize());
    }

    @Test(expected=EJBTransactionRolledbackException.class)
    @InSequence(value=2)
    @OperateOnDeployment(value="dep.active-1")
    public void testRegisterConstraint() throws Exception {
        Member newMember = this.memberRegistration.getNewMember();
        newMember.setName("Davide D'Altoe");
        newMember.setEmail("davide@mailinator.com");
        newMember.setPhoneNumber("2125551235");
        newMember.setLatitude(37.780392);
        newMember.setLongitude(-122.513898);
        this.memberRegistration.register();
    }

    @Test
    @InSequence(value=3)
    @OperateOnDeployment(value="dep.active-2")
    public void testNewMemberSearch() throws Exception {
        Member newMember = this.memberRegistration.getNewMember();
        newMember.setName("Peter O'Tall");
        newMember.setEmail("peter@mailinator.com");
        newMember.setPhoneNumber("4643646643");
        newMember.setLatitude(40.723165);
        newMember.setLongitude(-73.987439);
        this.memberRegistration.register();
        List<Member> search = this.memberRegistration.search("Peter");
        Assert.assertFalse((String)"Expected at least one result after the indexing", (boolean)search.isEmpty());
        Assert.assertEquals((String)"Search hasn't found a new member", (Object)newMember.getName(), (Object)search.get(0).getName());
        Assert.assertEquals((String)"Index size isn't correct", (long)2L, (long)this.memberRegistration.indexSize());
    }

    @Test
    @InSequence(value=4)
    @OperateOnDeployment(value="dep.active-2")
    public void testNewMemberLuceneSearch() throws Exception {
        List<Member> search = this.memberRegistration.luceneSearch("Peter");
        Assert.assertFalse((String)"Expected at least one result after the indexing", (boolean)search.isEmpty());
        Assert.assertEquals((String)"Lucene search hasn't found a member", (Object)"Peter O'Tall", (Object)search.get(0).getName());
    }

    @Test
    @InSequence(value=5)
    @OperateOnDeployment(value="dep.active-2")
    public void testNewMemberIndexSearch() throws Exception {
        List<Document> search = this.memberRegistration.indexSearch("Peter");
        Assert.assertFalse((String)"Expected at least one result after the indexing", (boolean)search.isEmpty());
        Assert.assertEquals((String)"Lucene search hasn't found a member", (Object)"Peter O'Tall", (Object)search.get(0).get("name"));
    }

    @Test
    @InSequence(value=6)
    @OperateOnDeployment(value="dep.active-2")
    public void testNonExistingMember() throws Exception {
        List<Member> search = this.memberRegistration.search("TotallyInventedName");
        Assert.assertNotNull((String)"Search should never return null", search);
        Assert.assertTrue((String)"Search results should be empty", (boolean)search.isEmpty());
    }

    @Test
    @InSequence(value=7)
    @OperateOnDeployment(value="dep.active-2")
    public void testLuceneNonExistingMember() throws Exception {
        List<Member> search = this.memberRegistration.luceneSearch("TotallyInventedName");
        Assert.assertNotNull((String)"Search should never return null", search);
        Assert.assertTrue((String)"Search results should be empty", (boolean)search.isEmpty());
    }

    @Test
    @InSequence(value=8)
    @OperateOnDeployment(value="dep.active-2")
    public void testIndexNonExistingMember() throws Exception {
        List<Document> search = this.memberRegistration.indexSearch("TotallyInventedName");
        Assert.assertNotNull((String)"Search should never return null", search);
        Assert.assertTrue((String)"Search results should be empty", (boolean)search.isEmpty());
    }

    @Test
    @InSequence(value=9)
    @OperateOnDeployment(value="dep.active-2")
    public void testPurgeIndex() throws Exception {
        this.memberRegistration.purgeMemberIndex();
        List<Member> search = this.memberRegistration.search("Peter");
        Assert.assertNotNull((String)"Search should never return null", search);
        Assert.assertTrue((String)"Search results should be empty", (boolean)search.isEmpty());
        Assert.assertEquals((String)"Index size isn't correct", (long)0L, (long)this.memberRegistration.indexSize());
    }

    @Test
    @InSequence(value=10)
    @OperateOnDeployment(value="dep.active-2")
    public void testReIndex() throws Exception {
        this.memberRegistration.indexMembers();
        List<Member> search = this.memberRegistration.search("Peter");
        Assert.assertFalse((String)"Expected at least one result after the indexing", (boolean)search.isEmpty());
        Assert.assertEquals((String)"Search hasn't found a new member after reindex", (Object)"Peter O'Tall", (Object)search.get(0).getName());
        Assert.assertEquals((String)"Index size isn't correct", (long)2L, (long)this.memberRegistration.indexSize());
    }

    @Test
    @InSequence(value=11)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchNearGD() throws Exception {
        List<Member> members = this.memberRegistration.spatialSearch(37.769645, -122.446428, 10.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)1L, (long)members.size());
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Davide D'Alto", (Object)members.get(0).getName());
    }

    @Test
    @InSequence(value=12)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchNearGDWithDistance() throws Exception {
        List<Object[]> membersWithDistance = this.memberRegistration.spatialSearchWithDistance(37.769645, -122.446428, 10.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)1L, (long)membersWithDistance.size());
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Davide D'Alto", (Object)((Member)membersWithDistance.get(0)[1]).getName());
        Assert.assertTrue((String)"Distance was not greater than zero", ((Double)membersWithDistance.get(0)[0] > 0.0 ? 1 : 0) != 0);
    }

    @Test
    @InSequence(value=13)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchNearCBGB() throws Exception {
        List<Member> members = this.memberRegistration.spatialSearch(40.726157, -73.992116, 10.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)1L, (long)members.size());
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Peter O'Tall", (Object)members.get(0).getName());
    }

    @Test
    @InSequence(value=14)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchNearCBGBWithDistance() throws Exception {
        List<Object[]> membersWithDistance = this.memberRegistration.spatialSearchWithDistance(40.726157, -73.992116, 10.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)1L, (long)membersWithDistance.size());
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Peter O'Tall", (Object)((Member)membersWithDistance.get(0)[1]).getName());
        Assert.assertTrue((String)"Distance was not greater than zero", ((Double)membersWithDistance.get(0)[0] > 0.0 ? 1 : 0) != 0);
    }

    @Test
    @InSequence(value=15)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchNearBG() throws Exception {
        List<Member> members = this.memberRegistration.spatialSearch(41.874808, -87.625983, 10.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)0L, (long)members.size());
    }

    @Test
    @InSequence(value=16)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchNearBGWithDistance() throws Exception {
        List<Object[]> membersWithDistance = this.memberRegistration.spatialSearchWithDistance(41.874808, -87.625983, 10.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)0L, (long)membersWithDistance.size());
    }

    @Test
    @InSequence(value=17)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchLongDistance() throws Exception {
        List<Member> members = this.memberRegistration.spatialSearch(37.769645, -122.446428, 5000.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)2L, (long)members.size());
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Davide D'Alto", (Object)members.get(0).getName());
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Peter O'Tall", (Object)members.get(1).getName());
    }

    @Test
    @InSequence(value=18)
    @OperateOnDeployment(value="dep.active-1")
    public void testNewMemberSpatialSearchLongDistanceWithDistance() throws Exception {
        List<Object[]> membersWithDistance = this.memberRegistration.spatialSearchWithDistance(37.769645, -122.446428, 5000.0);
        Assert.assertEquals((String)"Expected one result from spatial search", (long)2L, (long)membersWithDistance.size());
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Davide D'Alto", (Object)((Member)membersWithDistance.get(0)[1]).getName());
        Assert.assertTrue((String)"Distance was not greater than zero", ((Double)membersWithDistance.get(0)[0] > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Spatial search did not find the correct member", (Object)"Peter O'Tall", (Object)((Member)membersWithDistance.get(1)[1]).getName());
        Assert.assertTrue((String)"Distance was not greater than zero", ((Double)membersWithDistance.get(1)[0] > 0.0 ? 1 : 0) != 0);
    }
}

