/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.wildfly.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Stateful;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.Unit;
import org.infinispan.test.integration.as.wildfly.model.Member;

@Stateful
@Model
public class MemberRegistration {
    @PersistenceContext
    private EntityManager em;
    private Member newMember;

    @Produces
    @Named
    public Member getNewMember() {
        return this.newMember;
    }

    public void register() throws Exception {
        this.register(this.newMember);
    }

    public void register(Member member) throws Exception {
        this.em.persist((Object)member);
        this.initNewMember();
    }

    public List<Member> search(String name) {
        Query luceneQuery = Search.getFullTextEntityManager((EntityManager)this.em).getSearchFactory().buildQueryBuilder().forEntity(Member.class).get().keyword().onField("name").matching((Object)name).createQuery();
        return Search.getFullTextEntityManager((EntityManager)this.em).createFullTextQuery(luceneQuery, new Class[0]).getResultList();
    }

    public List<Member> spatialSearch(double latitude, double longitude, double distanceinKM) {
        Query spatialQuery = Search.getFullTextEntityManager((EntityManager)this.em).getSearchFactory().buildQueryBuilder().forEntity(Member.class).get().spatial().within(distanceinKM, Unit.KM).ofLatitude(latitude).andLongitude(longitude).createQuery();
        return Search.getFullTextEntityManager((EntityManager)this.em).createFullTextQuery(spatialQuery, new Class[]{Member.class}).getResultList();
    }

    public List<Object[]> spatialSearchWithDistance(double latitude, double longitude, double distanceinKM) {
        Query spatialQuery = Search.getFullTextEntityManager((EntityManager)this.em).getSearchFactory().buildQueryBuilder().forEntity(Member.class).get().spatial().within(distanceinKM, Unit.KM).ofLatitude(latitude).andLongitude(longitude).createQuery();
        FullTextQuery hibQuery = Search.getFullTextEntityManager((EntityManager)this.em).createFullTextQuery(spatialQuery, new Class[]{Member.class});
        hibQuery.setProjection(new String[]{"_HSearch_SpatialDistance", "__HSearch_This"});
        hibQuery.setSpatialParameters(latitude, longitude, "_hibernate_default_coordinates");
        return hibQuery.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> indexSearch(String name) throws IOException {
        ArrayList<Document> result = new ArrayList<Document>();
        SearchFactory searchFactory = Search.getFullTextEntityManager((EntityManager)this.em).getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{Member.class});
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                Document member = reader.document(i);
                if (member == null || !member.get("name").contains(name)) continue;
                result.add(member);
            }
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(reader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexSize() {
        SearchFactory searchFactory = Search.getFullTextEntityManager((EntityManager)this.em).getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{Member.class});
        try {
            int n = reader.maxDoc();
            return n;
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(reader);
        }
    }

    public List<Member> luceneSearch(String name) throws ParseException {
        QueryParser parser = new QueryParser("name", (Analyzer)new StandardAnalyzer());
        Query luceneQuery = parser.parse(name);
        return Search.getFullTextEntityManager((EntityManager)this.em).createFullTextQuery(luceneQuery, new Class[0]).getResultList();
    }

    public void purgeMemberIndex() {
        Search.getFullTextEntityManager((EntityManager)this.em).purgeAll(Member.class);
    }

    public void indexMembers() throws InterruptedException {
        MassIndexer mi = Search.getFullTextEntityManager((EntityManager)this.em).createIndexer(new Class[]{Member.class});
        mi.startAndWait();
    }

    @PostConstruct
    public void initNewMember() {
        this.newMember = new Member();
    }
}

