/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.grouping.GroupingSearch;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InfinispanLuceneDirectoryIT {
    private Directory directory;
    private EmbeddedCacheManager cacheManager;
    private Cache<?, ?> cache;

    @Before
    public void setup() {
        this.cacheManager = new DefaultCacheManager();
        this.cacheManager.defineConfiguration("index", new ConfigurationBuilder().build());
        this.cache = this.cacheManager.getCache("index");
        this.directory = DirectoryBuilder.newDirectoryInstance(this.cache, this.cache, this.cache, (String)"index").create();
    }

    @After
    public void tearDown() throws IOException {
        this.directory.close();
        this.cache.stop();
        this.cacheManager.stop();
    }

    @Deployment
    public static Archive<?> deployment() {
        String dependencies = InfinispanLuceneDirectoryIT.deps(InfinispanLuceneDirectoryIT.dep("org.infinispan", Version.getModuleSlot()), InfinispanLuceneDirectoryIT.dep("org.infinispan.lucene-directory", Version.getModuleSlot()));
        StringAsset manifest = new StringAsset(((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", dependencies)).exportAsString());
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"lucene.war")).addClass(InfinispanLuceneDirectoryIT.class)).add((Asset)manifest, "META-INF/MANIFEST.MF");
    }

    @Test
    public void testCoreLucene() throws IOException {
        Document document = this.buildSimpleLuceneDoc("field1", "The quick brown fox jumped over the lazy dog");
        this.index(document);
        Assert.assertEquals((long)9L, (long)this.terms("field1").size());
    }

    @Test
    public void testQParserLucene() throws IOException, ParseException {
        Document document = this.buildSimpleLuceneDoc("field1", "The quick brown fox jumped over the lazy dog");
        this.index(document);
        Query matchingQuery = this.buildQuery("field1:box~");
        Query nonMatchingQuery = this.buildQuery("-field1:over");
        IndexSearcher indexSearcher = this.openSearcher();
        Assert.assertEquals((long)1L, (long)indexSearcher.search((Query)matchingQuery, (int)1).totalHits);
        Assert.assertEquals((long)0L, (long)indexSearcher.search((Query)nonMatchingQuery, (int)1).totalHits);
    }

    @Test
    public void testGrouping() throws IOException {
        Document doc1 = this.buildDocValueLuceneDoc("field1", "value1");
        Document doc2 = this.buildDocValueLuceneDoc("field1", "value1");
        Document doc3 = this.buildDocValueLuceneDoc("field1", "value2");
        this.index(doc1, doc2, doc3);
        GroupingSearch groupingSearch = new GroupingSearch("field1");
        TopGroups topGroups = groupingSearch.search(this.openSearcher(), (Query)new MatchAllDocsQuery(), 0, 10);
        Assert.assertEquals((long)3L, (long)topGroups.totalHitCount);
        Assert.assertEquals((long)2L, (long)topGroups.groups.length);
    }

    @Test
    public void testFaceting() throws Exception {
        Directory taxonomyDirectory = DirectoryBuilder.newDirectoryInstance(this.cache, this.cache, this.cache, (String)"taxonomy").create();
        DirectoryTaxonomyWriter tw = new DirectoryTaxonomyWriter(taxonomyDirectory);
        FacetsConfig cfg = new FacetsConfig();
        Document doc1 = new Document();
        Document doc2 = new Document();
        Document doc3 = new Document();
        doc1.add((IndexableField)new FacetField("category", new String[]{"c2"}));
        doc2.add((IndexableField)new FacetField("category", new String[]{"c2"}));
        doc3.add((IndexableField)new FacetField("category", new String[]{"c1"}));
        this.index(cfg.build((TaxonomyWriter)tw, doc1), cfg.build((TaxonomyWriter)tw, doc2), cfg.build((TaxonomyWriter)tw, doc3));
        tw.close();
        DirectoryTaxonomyReader tr = new DirectoryTaxonomyReader(taxonomyDirectory);
        FacetsCollector fc = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)this.openSearcher(), (Query)new MatchAllDocsQuery(), (int)10, (Collector)fc);
        FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts((TaxonomyReader)tr, cfg, fc);
        FacetResult category = facets.getTopChildren(10, "category", new String[0]);
        Assert.assertEquals((long)2L, (long)category.childCount);
    }

    private Query buildQuery(String q) throws ParseException {
        QueryParser queryParser = new QueryParser("field1", (Analyzer)new WhitespaceAnalyzer());
        return queryParser.parse(q);
    }

    private IndexSearcher openSearcher() throws IOException {
        return new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.directory));
    }

    private Terms terms(String field) throws IOException {
        DirectoryReader reader = DirectoryReader.open((Directory)this.directory);
        LeafReaderContext readerContext = (LeafReaderContext)reader.getContext().leaves().iterator().next();
        return readerContext.reader().terms(field);
    }

    private void index(Document ... documents) throws IOException {
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer());
        IndexWriter indexWriter = new IndexWriter(this.directory, iwc);
        for (Document doc : documents) {
            indexWriter.addDocument((Iterable)doc);
        }
        indexWriter.close();
    }

    private Document buildDocValueLuceneDoc(String fieldName, String contents) {
        Document document = new Document();
        SortedDocValuesField field = new SortedDocValuesField(fieldName, new BytesRef((CharSequence)contents));
        document.add((IndexableField)field);
        return document;
    }

    private Document buildSimpleLuceneDoc(String fieldName, String contents) {
        Document document = new Document();
        TextField field = new TextField(fieldName, contents, Field.Store.NO);
        document.add((IndexableField)field);
        return document;
    }

    private static String dep(String name, String version) {
        return name + ":" + version + " services";
    }

    private static String deps(String ... dep) {
        return String.join((CharSequence)",", dep);
    }
}

