/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestQueryMode;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestEntityAdaptorOkHttp;
import org.infinispan.commons.api.CacheContainerAdmin;

public class RestCacheClientOkHttp
implements RestCacheClient {
    private final RestClientOkHttp client;
    private final String name;
    private final String cacheUrl;

    RestCacheClientOkHttp(RestClientOkHttp restClient, String name) {
        this.client = restClient;
        this.name = name;
        this.cacheUrl = String.format("%s%s/v2/caches/%s", restClient.getBaseURL(), restClient.getConfiguration().contextPath(), RestClientOkHttp.sanitize(name));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CompletionStage<RestResponse> clear() {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(this.cacheUrl + "?action=clear");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> exists() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl).head();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> synchronizeData(Integer readBatch, Integer threads) {
        Request.Builder builder = new Request.Builder();
        StringBuilder sb = new StringBuilder(this.cacheUrl + "?action=sync-data");
        if (readBatch != null) {
            sb.append("&read-batch=").append(readBatch);
        }
        if (threads != null) {
            sb.append("&threads=").append(threads);
        }
        builder.post(RestClientOkHttp.EMPTY_BODY).url(sb.toString());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> synchronizeData() {
        return this.synchronizeData(null, null);
    }

    @Override
    public CompletionStage<RestResponse> disconnectSource() {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(this.cacheUrl + "?action=disconnect-source");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> size() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=size").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, String value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, RestEntity value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, String value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> post(String key, RestEntity value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).post(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String keyContentType, RestEntity value) {
        Request.Builder builder = new Request.Builder();
        if (keyContentType != null) {
            builder.addHeader("Key-Content-Type", keyContentType);
        }
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value, String ... flags) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        if (flags.length > 0) {
            builder.header("flags", String.join((CharSequence)",", flags));
        }
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, String value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(RequestBody.create((MediaType)RestClientOkHttp.TEXT_PLAIN, (String)value));
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> put(String key, RestEntity value, long ttl, long maxIdle) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key)).put(((RestEntityAdaptorOkHttp)((Object)value)).toRequestBody());
        this.addExpirationHeaders(builder, ttl, maxIdle);
        return this.client.execute(builder);
    }

    private void addExpirationHeaders(Request.Builder builder, long ttl, long maxIdle) {
        if (ttl != 0L) {
            builder.addHeader("timeToLiveSeconds", Long.toString(ttl));
        }
        if (maxIdle != 0L) {
            builder.addHeader("maxIdleTimeSeconds", Long.toString(maxIdle));
        }
    }

    @Override
    public CompletionStage<RestResponse> get(String key) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> get(String key, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key));
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> get(String key, String mediaType) {
        return this.get(key, mediaType, false);
    }

    @Override
    public CompletionStage<RestResponse> get(String key, String mediaType, boolean extended) {
        Request.Builder builder = new Request.Builder();
        String url = this.cacheUrl + "/" + RestClientOkHttp.sanitize(key);
        if (extended) {
            url = url + "?extended=true";
        }
        builder.url(url);
        builder.header("Accept", mediaType);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> head(String key) {
        return this.head(key, Collections.emptyMap());
    }

    @Override
    public CompletionStage<RestResponse> head(String key, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key) + "?extended").head();
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> remove(String key) {
        return this.remove(key, Collections.emptyMap());
    }

    @Override
    public CompletionStage<RestResponse> remove(String key, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/" + RestClientOkHttp.sanitize(key) + "?extended").delete();
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> createWithTemplate(String template, CacheContainerAdmin.AdminFlag ... flags) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?template=" + template).post(RestClientOkHttp.EMPTY_BODY);
        RestClientOkHttp.addEnumHeader("flags", builder, (Enum[])flags);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> createWithConfiguration(RestEntity configuration, CacheContainerAdmin.AdminFlag ... flags) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl).post(((RestEntityAdaptorOkHttp)((Object)configuration)).toRequestBody());
        RestClientOkHttp.addEnumHeader("flags", builder, (Enum[])flags);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> delete() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl).delete();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> keys() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=keys").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> keys(int limit) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=keys&limit=" + limit).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> entries() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=entries").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> entries(int limit) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=entries&limit=" + limit).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> entries(int limit, boolean metadata) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=entries&metadata=" + metadata + "&limit=" + limit).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> keys(String mediaType) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=keys").get();
        builder.header("Accept", mediaType);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> configuration(String mediaType) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=config");
        if (mediaType != null) {
            builder.header("Accept", mediaType);
        }
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> stats() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=stats").get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> query(String query) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "?action=search&query=" + RestClientOkHttp.sanitize(query)).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> query(String query, int maxResults, int offset, RestQueryMode queryMode) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s?action=search&query=%s&max_results=%d&offset=%d&query_mode=%s", this.cacheUrl, RestClientOkHttp.sanitize(query), maxResults, offset, queryMode.name())).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> xsiteBackups() {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/", this.cacheUrl));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> backupStatus(String site) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/%s", this.cacheUrl, site));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> takeSiteOffline(String site) {
        return this.executeXSiteOperation(site, "take-offline");
    }

    @Override
    public CompletionStage<RestResponse> bringSiteOnline(String site) {
        return this.executeXSiteOperation(site, "bring-online");
    }

    @Override
    public CompletionStage<RestResponse> pushSiteState(String site) {
        return this.executeXSiteOperation(site, "start-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelPushState(String site) {
        return this.executeXSiteOperation(site, "cancel-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelReceiveState(String site) {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(String.format("%s/x-site/backups/%s?action=%s", this.cacheUrl, site, "cancel-receive-state"));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> pushStateStatus() {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups?action=push-state-status", this.cacheUrl));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> clearPushStateStatus() {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(String.format("%s/x-site/local?action=clear-push-state-status", this.cacheUrl));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> getXSiteTakeOfflineConfig(String site) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.format("%s/x-site/backups/%s/take-offline-config", this.cacheUrl, site));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> updateXSiteTakeOfflineConfig(String site, int afterFailures, long minTimeToWait) {
        Request.Builder builder = new Request.Builder();
        String url = String.format("%s/x-site/backups/%s/take-offline-config", this.cacheUrl, site);
        String body = String.format("{\"after_failures\":%d,\"min_wait\":%d}", afterFailures, minTimeToWait);
        builder.url(url);
        builder.method("PUT", RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body));
        return this.client.execute(builder);
    }

    private CompletionStage<RestResponse> executeXSiteOperation(String site, String action) {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(String.format("%s/x-site/backups/%s?action=%s", this.cacheUrl, site, action));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> reindex() {
        return this.executeIndexOperation("mass-index");
    }

    @Override
    public CompletionStage<RestResponse> clearIndex() {
        return this.executeIndexOperation("clear");
    }

    @Override
    public CompletionStage<RestResponse> queryStats() {
        return this.executeSearchStatOperation("query", null);
    }

    @Override
    public CompletionStage<RestResponse> indexStats() {
        return this.executeSearchStatOperation("indexes", null);
    }

    @Override
    public CompletionStage<RestResponse> clearQueryStats() {
        return this.executeSearchStatOperation("query", "clear");
    }

    private CompletionStage<RestResponse> executeIndexOperation(String action) {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(String.format("%s/search/indexes?action=%s", this.cacheUrl, action));
        return this.client.execute(builder);
    }

    private CompletionStage<RestResponse> executeSearchStatOperation(String type, String action) {
        Request.Builder builder = new Request.Builder();
        String url = String.format("%s/search/%s/stats", this.cacheUrl, type);
        if (action != null) {
            url = url + "?action=" + action;
            builder.post(RestClientOkHttp.EMPTY_BODY);
        }
        builder.url(url);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> details() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl).get();
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> searchStats() {
        Request.Builder builder = new Request.Builder();
        builder.url(this.cacheUrl + "/search/stats");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> clearSearchStats() {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(this.cacheUrl + "/search/stats?action=clear");
        return this.client.execute(builder);
    }
}

