/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.manager;

import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.lock.BaseClusteredLockTest;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockConfiguration;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.api.OwnershipLevel;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.impl.lock.ClusteredLockImpl;
import org.infinispan.test.Exceptions;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="clusteredLock.EmbeddedClusteredLockManagerTest")
public class EmbeddedClusteredLockManagerTest
extends BaseClusteredLockTest {
    private static final String LOCK_NAME = "EmbeddedClusteredLockManagerTest";

    @AfterMethod
    public void after() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
    }

    public void testDefineLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        AssertJUnit.assertTrue((boolean)clusteredLockManager.defineLock(LOCK_NAME, new ClusteredLockConfiguration()));
        AssertJUnit.assertFalse((boolean)clusteredLockManager.defineLock(LOCK_NAME, new ClusteredLockConfiguration()));
    }

    public void testGetWithLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        clusteredLockManager.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
        ClusteredLock lock = clusteredLockManager.get(LOCK_NAME);
        AssertJUnit.assertNotNull((Object)lock);
    }

    public void testGetWithLockDefinitionFromAnotherNode() {
        ClusteredLockManager cm0 = this.clusteredLockManager(0);
        cm0.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
        ClusteredLockImpl lock0 = (ClusteredLockImpl)cm0.get(LOCK_NAME);
        ClusteredLockManager cm1 = this.clusteredLockManager(1);
        ClusteredLockImpl lock1 = (ClusteredLockImpl)cm1.get(LOCK_NAME);
        AssertJUnit.assertNotNull((Object)lock0);
        AssertJUnit.assertNotNull((Object)lock1);
        AssertJUnit.assertEquals((String)lock0.getName(), (String)lock1.getName());
        AssertJUnit.assertEquals((Object)this.manager(0).getAddress(), (Object)lock0.getOriginator());
        AssertJUnit.assertEquals((Object)this.manager(1).getAddress(), (Object)lock1.getOriginator());
    }

    public void testGetWithoutLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        Exceptions.expectException(ClusteredLockException.class, () -> clusteredLockManager.get(LOCK_NAME));
    }

    public void testGetConfigurationWithLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        clusteredLockManager.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
        ClusteredLockConfiguration configuration = clusteredLockManager.getConfiguration(LOCK_NAME);
        AssertJUnit.assertEquals((Object)OwnershipLevel.NODE, (Object)configuration.getOwnershipLevel());
        AssertJUnit.assertFalse((boolean)configuration.isReentrant());
    }

    public void testGetConfigurationWithoutLockDefinition() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        Exceptions.expectException(ClusteredLockException.class, () -> clusteredLockManager.getConfiguration(LOCK_NAME));
    }

    public void testIsDefined() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        AssertJUnit.assertFalse((boolean)clusteredLockManager.isDefined(LOCK_NAME));
        clusteredLockManager.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
        AssertJUnit.assertTrue((boolean)clusteredLockManager.isDefined(LOCK_NAME));
    }

    public void testForceRelease() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        clusteredLockManager.defineLock(LOCK_NAME, new ClusteredLockConfiguration());
        ClusteredLock lock = clusteredLockManager.get(LOCK_NAME);
        FunctionalTestUtils.await((CompletableFuture)lock.lock());
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.isLocked())));
        AssertJUnit.assertTrue((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.forceRelease(LOCK_NAME))));
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)lock.isLocked())));
    }

    public void testForceReleaseUndefinedLock() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        AssertJUnit.assertFalse((boolean)((Boolean)FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.forceRelease(LOCK_NAME))));
    }

    public void testRemove() {
        ClusteredLockManager clusteredLockManager = this.clusteredLockManager(0);
        Cache clusteredLocksCache = this.cache(0, "org.infinispan.LOCKS");
        int beforeSize = clusteredLocksCache.getListeners().size();
        clusteredLockManager.defineLock(LOCK_NAME);
        clusteredLockManager.get(LOCK_NAME);
        int afterSize = clusteredLocksCache.getListeners().size();
        AssertJUnit.assertTrue((beforeSize < afterSize ? 1 : 0) != 0);
        FunctionalTestUtils.await((CompletableFuture)clusteredLockManager.remove(LOCK_NAME));
        int afterRemoveSize = clusteredLocksCache.getListeners().size();
        AssertJUnit.assertFalse((boolean)clusteredLockManager.isDefined(LOCK_NAME));
        AssertJUnit.assertTrue((beforeSize == afterRemoveSize ? 1 : 0) != 0);
    }
}

