/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search;

import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.infinispan.hibernate.search.SimpleEmail;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class AsyncMetadataConfigurationTest {
    @Rule
    public BytemanHelper.BytemanAccessor byteman = BytemanHelper.createAccessor();

    @Test
    @BMRule(targetClass="org.infinispan.lucene.impl.DirectoryBuilderImpl", targetMethod="create", helper="org.hibernate.search.testsupport.BytemanHelper", action="assertBooleanValue($0.writeFileListAsync, true); countInvocation();", name="verifyAsyncMetadataOptionApplied")
    public void verifyAsyncMetadataOptionApplied() throws Exception {
        this.buildSearchFactoryWithAsyncOption(false, true);
    }

    @Test
    @BMRule(targetClass="org.infinispan.lucene.impl.DirectoryBuilderImpl", targetMethod="create", helper="org.hibernate.search.testsupport.BytemanHelper", action="assertBooleanValue($0.writeFileListAsync, false); countInvocation();", name="verifyAsyncMetadataDisabledByDefault")
    public void verifyAsyncMetadataDisabledByDefault() throws Exception {
        this.buildSearchFactoryWithAsyncOption(false, null);
    }

    @Test
    @BMRule(targetClass="org.infinispan.lucene.impl.DirectoryBuilderImpl", targetMethod="create", helper="org.hibernate.search.testsupport.BytemanHelper", action="assertBooleanValue($0.writeFileListAsync, false); countInvocation();", name="verifyAsyncMetadataOptionExplicitDisabled")
    public void verifyAsyncMetadataOptionExplicitDisabled() throws Exception {
        this.buildSearchFactoryWithAsyncOption(false, false);
    }

    @Test
    @BMRule(targetClass="org.infinispan.lucene.impl.DirectoryBuilderImpl", targetMethod="create", helper="org.hibernate.search.testsupport.BytemanHelper", action="assertBooleanValue($0.writeFileListAsync, false); countInvocation();", name="verifyAsyncMetadataOptionExplicitlyDisabledForAsyncBackend")
    public void verifyAsyncMetadataOptionExplicitlyDisabledForAsyncBackend() throws Exception {
        this.buildSearchFactoryWithAsyncOption(true, false);
    }

    private void buildSearchFactoryWithAsyncOption(Boolean backendAsync, Boolean async) {
        SearchConfigurationForTest configuration = new HibernateManualConfiguration().addClass(SimpleEmail.class).addProperty("hibernate.search.default.directory_provider", "infinispan").addProperty("hibernate.search.infinispan.configuration_resourcename", "localonly-infinispan.xml");
        if (backendAsync != null) {
            configuration.addProperty("hibernate.search.default.worker.execution", backendAsync != false ? "async" : "sync");
        }
        if (async != null) {
            configuration.addProperty("hibernate.search.default.write_metadata_async", async.toString());
        }
        try (SearchIntegrator ignored = new SearchIntegratorBuilder().configuration((SearchConfiguration)configuration).buildSearchIntegrator();){
            Assert.assertEquals((String)"The directory provider was not started", (long)1L, (long)this.byteman.getAndResetInvocationCount());
        }
    }
}

