/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.logging;

import infinispan.org.jboss.logging.AbstractLoggerProvider;
import infinispan.org.jboss.logging.Logger;
import infinispan.org.jboss.logging.LoggerProvider;
import infinispan.org.jboss.logging.Slf4jLocationAwareLogger;
import infinispan.org.jboss.logging.Slf4jLogger;
import infinispan.org.slf4j.LoggerFactory;
import infinispan.org.slf4j.MDC;
import infinispan.org.slf4j.spi.LocationAwareLogger;
import java.util.Map;

final class Slf4jLoggerProvider
extends AbstractLoggerProvider
implements LoggerProvider {
    Slf4jLoggerProvider() {
    }

    @Override
    public Logger getLogger(String name) {
        infinispan.org.slf4j.Logger l = LoggerFactory.getLogger(name);
        try {
            return new Slf4jLocationAwareLogger(name, (LocationAwareLogger)l);
        }
        catch (Throwable throwable) {
            return new Slf4jLogger(name, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putMdc(String key, Object value) {
        try {
            String string = MDC.get(key);
            return string;
        }
        finally {
            if (value == null) {
                MDC.remove(key);
            } else {
                MDC.put(key, String.valueOf(value));
            }
        }
    }

    @Override
    public Object getMdc(String key) {
        return MDC.get(key);
    }

    @Override
    public void removeMdc(String key) {
        MDC.remove(key);
    }

    @Override
    public Map<String, Object> getMdcMap() {
        return MDC.getCopyOfContextMap();
    }
}

