/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.Version;

public class TrimFilterFactory
extends TokenFilterFactory {
    protected final boolean updateOffsets;

    public TrimFilterFactory(Map<String, String> args) {
        super(args);
        this.updateOffsets = this.getBoolean(args, "updateOffsets", false);
        if (this.updateOffsets && (this.luceneMatchVersion == null || this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0))) {
            throw new IllegalArgumentException("updateOffsets=true is not supported anymore as of Lucene 4.4");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TrimFilter create(TokenStream input) {
        if (this.luceneMatchVersion == null) {
            return new TrimFilter(input);
        }
        TrimFilter filter = new TrimFilter(this.luceneMatchVersion, input, this.updateOffsets);
        return filter;
    }
}

