/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public class DefaultSortedSetDocValuesReaderState
extends SortedSetDocValuesReaderState {
    private final String field;
    private final AtomicReader topReader;
    private final int valueCount;
    public final IndexReader origReader;
    private final Map<String, SortedSetDocValuesReaderState.OrdRange> prefixToOrdRange = new HashMap<String, SortedSetDocValuesReaderState.OrdRange>();

    public DefaultSortedSetDocValuesReaderState(IndexReader reader) throws IOException {
        this(reader, "$facets");
    }

    public DefaultSortedSetDocValuesReaderState(IndexReader reader, String field) throws IOException {
        this.field = field;
        this.origReader = reader;
        this.topReader = SlowCompositeReaderWrapper.wrap(reader);
        SortedSetDocValues dv = this.topReader.getSortedSetDocValues(field);
        if (dv == null) {
            throw new IllegalArgumentException("field \"" + field + "\" was not indexed with SortedSetDocValues");
        }
        if (dv.getValueCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can only handle valueCount < Integer.MAX_VALUE; got " + dv.getValueCount());
        }
        this.valueCount = (int)dv.getValueCount();
        Object lastDim = null;
        int startOrd = -1;
        for (int ord = 0; ord < this.valueCount; ++ord) {
            BytesRef term = dv.lookupOrd(ord);
            Object[] components = FacetsConfig.stringToPath(term.utf8ToString());
            if (components.length != 2) {
                throw new IllegalArgumentException("this class can only handle 2 level hierarchy (dim/value); got: " + Arrays.toString(components) + " " + term.utf8ToString());
            }
            if (components[0].equals(lastDim)) continue;
            if (lastDim != null) {
                this.prefixToOrdRange.put((String)lastDim, new SortedSetDocValuesReaderState.OrdRange(startOrd, ord - 1));
            }
            startOrd = ord;
            lastDim = components[0];
        }
        if (lastDim != null) {
            this.prefixToOrdRange.put((String)lastDim, new SortedSetDocValuesReaderState.OrdRange(startOrd, this.valueCount - 1));
        }
    }

    @Override
    public SortedSetDocValues getDocValues() throws IOException {
        return this.topReader.getSortedSetDocValues(this.field);
    }

    @Override
    public Map<String, SortedSetDocValuesReaderState.OrdRange> getPrefixToOrdRange() {
        return this.prefixToOrdRange;
    }

    @Override
    public SortedSetDocValuesReaderState.OrdRange getOrdRange(String dim) {
        return this.prefixToOrdRange.get(dim);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public IndexReader getOrigReader() {
        return this.origReader;
    }

    @Override
    public int getSize() {
        return this.valueCount;
    }
}

