/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.OrdinalMappingAtomicReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.store.Directory;

public abstract class TaxonomyMergeUtils {
    private TaxonomyMergeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(Directory srcIndexDir, Directory srcTaxoDir, DirectoryTaxonomyWriter.OrdinalMap map, IndexWriter destIndexWriter, DirectoryTaxonomyWriter destTaxoWriter, FacetsConfig srcConfig) throws IOException {
        destTaxoWriter.addTaxonomy(srcTaxoDir, map);
        int[] ordinalMap = map.getMap();
        try (DirectoryReader reader = DirectoryReader.open(srcIndexDir);){
            List<AtomicReaderContext> leaves = reader.leaves();
            int numReaders = leaves.size();
            IndexReader[] wrappedLeaves = new AtomicReader[numReaders];
            for (int i = 0; i < numReaders; ++i) {
                wrappedLeaves[i] = new OrdinalMappingAtomicReader(leaves.get(i).reader(), ordinalMap, srcConfig);
            }
            destIndexWriter.addIndexes(new MultiReader(wrappedLeaves));
            destTaxoWriter.commit();
            destIndexWriter.commit();
        }
    }
}

