/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;

public final class TermFilter
extends Filter {
    private final Term term;

    public TermFilter(Term term) {
        if (term == null) {
            throw new IllegalArgumentException("Term must not be null");
        }
        if (term.field() == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, final Bits acceptDocs) throws IOException {
        Terms terms = context.reader().terms(this.term.field());
        if (terms == null) {
            return null;
        }
        final TermsEnum termsEnum = terms.iterator(null);
        if (!termsEnum.seekExact(this.term.bytes())) {
            return null;
        }
        return new DocIdSet(){

            @Override
            public DocIdSetIterator iterator() throws IOException {
                return termsEnum.docs(acceptDocs, null, 0);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermFilter that = (TermFilter)o;
        return !(this.term != null ? !this.term.equals(that.term) : that.term != null);
    }

    public int hashCode() {
        return this.term != null ? this.term.hashCode() : 0;
    }

    public String toString() {
        return this.term.field() + ":" + this.term.text();
    }
}

