/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.ClassBasedLuceneQueryResolverDelegate;
import org.hibernate.hql.lucene.internal.LuceneQueryRendererDelegate;
import org.hibernate.hql.lucene.internal.UntypedLuceneQueryResolverDelegate;
import org.hibernate.hql.lucene.internal.builder.ClassBasedLucenePropertyHelper;
import org.hibernate.hql.lucene.internal.builder.FieldBridgeProviderBasedLucenePropertyHelper;
import org.hibernate.hql.lucene.internal.builder.LucenePropertyHelper;
import org.hibernate.hql.lucene.internal.builder.predicate.LucenePredicateFactory;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.spi.SearchIntegrator;

public class LuceneProcessingChain
implements AstProcessingChain<LuceneQueryParsingResult> {
    private final QueryResolverProcessor resolverProcessor;
    private final QueryRendererProcessor rendererProcessor;
    private final LuceneQueryRendererDelegate rendererDelegate;

    private LuceneProcessingChain(QueryResolverProcessor resolverProcessor, QueryRendererProcessor rendererProcessor, LuceneQueryRendererDelegate rendererDelegate) {
        this.resolverProcessor = resolverProcessor;
        this.rendererProcessor = rendererProcessor;
        this.rendererDelegate = rendererDelegate;
    }

    @Override
    public Iterator<AstProcessor> iterator() {
        return Arrays.asList(this.resolverProcessor, this.rendererProcessor).iterator();
    }

    @Override
    public LuceneQueryParsingResult getResult() {
        return this.rendererDelegate.getResult();
    }

    public static class Builder {
        private final SearchIntegrator searchFactory;
        private final EntityNamesResolver entityNames;
        private Map<String, Object> namedParameters;

        public Builder(SearchIntegrator searchFactory, EntityNamesResolver entityNames) {
            this.searchFactory = searchFactory;
            this.entityNames = entityNames;
        }

        public Builder namedParameters(Map<String, Object> namedParameters) {
            this.namedParameters = namedParameters;
            return this;
        }

        public LuceneProcessingChain buildProcessingChainForDynamicEntities(FieldBridgeProvider fieldBridgeProvider) {
            QueryResolverProcessor resolverProcessor = new QueryResolverProcessor(new UntypedLuceneQueryResolverDelegate());
            LuceneQueryRendererDelegate rendererDelegate = Builder.getRendererDelegate(this.searchFactory, fieldBridgeProvider, this.entityNames, this.namedParameters, new FieldBridgeProviderBasedLucenePropertyHelper(fieldBridgeProvider));
            QueryRendererProcessor rendererProcessor = new QueryRendererProcessor(rendererDelegate);
            return new LuceneProcessingChain(resolverProcessor, rendererProcessor, rendererDelegate);
        }

        public LuceneProcessingChain buildProcessingChainForClassBasedEntities() {
            ClassBasedLucenePropertyHelper propertyHelper = new ClassBasedLucenePropertyHelper(this.searchFactory, this.entityNames);
            QueryResolverProcessor resolverProcessor = new QueryResolverProcessor(new ClassBasedLuceneQueryResolverDelegate(propertyHelper, this.entityNames));
            LuceneQueryRendererDelegate rendererDelegate = Builder.getRendererDelegate(this.searchFactory, null, this.entityNames, this.namedParameters, propertyHelper);
            QueryRendererProcessor rendererProcessor = new QueryRendererProcessor(rendererDelegate);
            return new LuceneProcessingChain(resolverProcessor, rendererProcessor, rendererDelegate);
        }

        private static LuceneQueryRendererDelegate getRendererDelegate(SearchIntegrator searchFactory, FieldBridgeProvider fieldBridgeProvider, EntityNamesResolver entityNames, Map<String, Object> namedParameters, LucenePropertyHelper propertyHelper) {
            SingleEntityQueryBuilder<Query> queryBuilder = SingleEntityQueryBuilder.getInstance(new LucenePredicateFactory(searchFactory.buildQueryBuilder(), entityNames, fieldBridgeProvider), propertyHelper);
            return new LuceneQueryRendererDelegate(entityNames, queryBuilder, namedParameters, propertyHelper);
        }
    }
}

