/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal;

import infinispan.org.antlr.runtime.tree.Tree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;

public class UntypedLuceneQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = LoggerFactory.make();
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private final Map<String, PropertyPath> aliasToPropertyPath = new HashMap<String, PropertyPath>();
    private String alias;

    @Override
    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
    }

    @Override
    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    @Override
    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        if (this.aliasToEntityType.containsKey(property.getText())) {
            return new PathedPropertyReference(property.getText(), null, true);
        }
        return new PathedPropertyReference(property.getText(), null, false);
    }

    @Override
    public boolean isPersisterReferenceAlias() {
        return true;
    }

    @Override
    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.aliasToEntityType.get(root.getText());
        if (entityNameForAlias == null) {
            PropertyPath propertyPath = this.aliasToPropertyPath.get(root.getText());
            if (propertyPath == null) {
                throw log.getUnknownAliasException(root.getText());
            }
            List<String> nodeNamesWithoutAlias = propertyPath.getNodeNamesWithoutAlias();
            StringBuilder builder = new StringBuilder();
            for (String name : nodeNamesWithoutAlias) {
                builder.append(".");
                builder.append(name);
            }
            return new PathedPropertyReference(builder.substring(1), null, false);
        }
        return new PathedPropertyReference(root.getText(), null, true);
    }

    @Override
    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        return new PathedPropertyReference(propertyName.getText(), null, false);
    }

    @Override
    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return new PathedPropertyReference(propertyNameNode.getText(), null, false);
    }

    @Override
    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.alias = alias.getText();
    }

    @Override
    public void pushSelectStrategy() {
    }

    @Override
    public void popStrategy() {
        this.alias = null;
    }

    @Override
    public void propertyPathCompleted(PropertyPath path) {
    }

    @Override
    public void registerJoinAlias(Tree alias, PropertyPath path) {
        if (!path.getNodes().isEmpty() && !this.aliasToPropertyPath.containsKey(alias)) {
            this.aliasToPropertyPath.put(alias.getText(), path);
        }
    }
}

