/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.engine.impl.WorkPlan;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class WorkQueue {
    private static final Log log = LoggerFactory.make();
    private WorkPlan plan;
    private List<LuceneWork> sealedQueue;
    private boolean sealedAndUnchanged;
    private final ExtendedSearchIntegrator extendedIntegrator;

    public WorkQueue(ExtendedSearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator;
        this.plan = new WorkPlan(extendedIntegrator);
    }

    public WorkQueue(ExtendedSearchIntegrator extendedIntegrator, WorkPlan plan) {
        this.extendedIntegrator = extendedIntegrator;
        this.plan = plan;
    }

    public void add(Work work) {
        this.sealedAndUnchanged = false;
        this.plan.addWork(work);
    }

    public WorkQueue splitQueue() {
        if (log.isTraceEnabled()) {
            log.tracef("Splitting work queue with %d works", (Object)this.plan.size());
        }
        WorkQueue subQueue = new WorkQueue(this.extendedIntegrator, this.plan);
        this.plan = new WorkPlan(this.extendedIntegrator);
        this.sealedAndUnchanged = false;
        return subQueue;
    }

    public List<LuceneWork> getSealedQueue() {
        if (this.sealedQueue == null) {
            throw new AssertionFailure("Access a WorkQueue which has not been sealed");
        }
        this.sealedAndUnchanged = false;
        return this.sealedQueue;
    }

    private void setSealedQueue(List<LuceneWork> sealedQueue) {
        this.sealedAndUnchanged = true;
        this.sealedQueue = sealedQueue;
    }

    public void clear() {
        if (log.isTraceEnabled()) {
            log.trace("Clearing current work queue");
        }
        this.plan.clear();
        this.sealedAndUnchanged = false;
        if (this.sealedQueue != null) {
            this.sealedQueue.clear();
        }
    }

    public int size() {
        return this.plan.size();
    }

    public void prepareWorkPlan() {
        if (!this.sealedAndUnchanged) {
            this.plan.processContainedInAndPrepareExecution();
            List<LuceneWork> luceneWorkPlan = this.plan.getPlannedLuceneWork();
            this.setSealedQueue(luceneWorkPlan);
        }
    }
}

