/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class OptimizeWorkExecutor
implements LuceneWorkExecutor {
    private static final Log log = LoggerFactory.make();
    private final Workspace workspace;

    OptimizeWorkExecutor(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
        Class<?> entityType = work.getEntityClass();
        log.tracef("optimize Lucene index: %s", (Object)entityType);
        this.workspace.performOptimization(writer);
    }
}

