/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.Map;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.impl.ScopedAnalyzer;

public class EmbeddedTypeMetadata
extends TypeMetadata {
    private final String embeddedFieldName;
    private final XMember embeddedGetter;
    private final Container embeddedContainer;
    private final String embeddedNullFieldName;
    private final String embeddedNullToken;
    private final FieldBridge embeddedNullFieldBridge;

    private EmbeddedTypeMetadata(Builder builder) {
        super(builder);
        this.embeddedFieldName = builder.embeddedFieldName;
        this.embeddedGetter = builder.embeddedGetter;
        this.embeddedContainer = builder.embeddedContainer;
        this.embeddedNullFieldName = builder.embeddedNullFieldName;
        this.embeddedNullToken = builder.embeddedNullToken;
        this.embeddedNullFieldBridge = builder.embeddedNullFieldBridge;
    }

    public String getEmbeddedFieldName() {
        return this.embeddedFieldName;
    }

    public XMember getEmbeddedGetter() {
        return this.embeddedGetter;
    }

    public Container getEmbeddedContainer() {
        return this.embeddedContainer;
    }

    public String getEmbeddedNullFieldName() {
        return this.embeddedNullFieldName;
    }

    public String getEmbeddedNullToken() {
        return this.embeddedNullToken;
    }

    public FieldBridge getEmbeddedNullFieldBridge() {
        return this.embeddedNullFieldBridge;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("EmbeddedTypeMetadata{");
        sb.append("embeddedFieldName='").append(this.embeddedFieldName).append('\'');
        sb.append(", embeddedGetter=").append(this.embeddedGetter);
        sb.append(", embeddedContainer=").append((Object)this.embeddedContainer);
        sb.append(", embeddedNullFieldName='").append(this.embeddedNullFieldName).append('\'');
        sb.append(", embeddedNullToken='").append(this.embeddedNullToken).append('\'');
        sb.append(", embeddedNullFieldBridge=").append(this.embeddedNullFieldBridge);
        sb.append('}');
        return sb.toString();
    }

    public static enum Container {
        OBJECT,
        COLLECTION,
        MAP,
        ARRAY;

    }

    public static class Builder
    extends TypeMetadata.Builder {
        private String embeddedFieldName;
        private XMember embeddedGetter;
        private Container embeddedContainer;
        private String embeddedNullFieldName;
        private String embeddedNullToken;
        private FieldBridge embeddedNullFieldBridge;

        public Builder(Class<?> indexedType, XMember embeddedGetter, ScopedAnalyzer scopedAnalyzer) {
            super(indexedType, scopedAnalyzer);
            ReflectionHelper.setAccessible(embeddedGetter);
            this.embeddedFieldName = embeddedGetter.getName();
            this.embeddedGetter = embeddedGetter;
            this.embeddedContainer = this.determineContainerType(embeddedGetter);
        }

        public Builder indexNullToken(String embeddedNullToken, String embeddedNullFieldName, FieldBridge embeddedNullFieldBridge) {
            this.embeddedNullToken = embeddedNullToken;
            this.embeddedNullFieldName = embeddedNullFieldName;
            this.embeddedNullFieldBridge = embeddedNullFieldBridge;
            return this;
        }

        public Container getEmbeddedContainerType() {
            return this.embeddedContainer;
        }

        @Override
        public EmbeddedTypeMetadata build() {
            return new EmbeddedTypeMetadata(this);
        }

        private Container determineContainerType(XMember member) {
            if (member.isArray()) {
                return Container.ARRAY;
            }
            if (member.isCollection()) {
                if (Map.class.equals(member.getCollectionClass())) {
                    return Container.MAP;
                }
                return Container.COLLECTION;
            }
            return Container.OBJECT;
        }
    }
}

