/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.filter.impl.AndDocIdSet;
import org.hibernate.search.filter.impl.FilterOptimizationHelper;

public class ChainedFilter
extends Filter {
    private static final long serialVersionUID = -6153052295766531920L;
    private final List<Filter> chainedFilters = new ArrayList<Filter>();

    public void addFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The specified filter cannot be null");
        }
        this.chainedFilters.add(filter);
    }

    public boolean removeFilter(Filter filter) {
        return this.chainedFilters.remove(filter);
    }

    public boolean isEmpty() {
        return this.chainedFilters.size() == 0;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        int size = this.chainedFilters.size();
        if (size == 0) {
            throw new AssertionFailure("No filters to chain");
        }
        if (size == 1) {
            return this.chainedFilters.get(0).getDocIdSet(context, acceptDocs);
        }
        List<DocIdSet> subSets = new ArrayList<DocIdSet>(size);
        for (Filter f : this.chainedFilters) {
            subSets.add(f.getDocIdSet(context, acceptDocs));
        }
        if ((subSets = FilterOptimizationHelper.mergeByBitAnds(subSets)).size() == 1) {
            return subSets.get(0);
        }
        AtomicReader reader = context.reader();
        return new AndDocIdSet(subSets, reader.maxDoc());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChainedFilter");
        sb.append("{chainedFilters=").append(this.chainedFilters);
        sb.append('}');
        return sb.toString();
    }
}

