/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.logging.impl;

import infinispan.org.jboss.logging.BasicLogger;
import infinispan.org.jboss.logging.DelegatingBasicLogger;
import infinispan.org.jboss.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.index.CorruptIndexException;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.avro.logging.impl.Log;
import org.hibernate.search.util.logging.impl.ClassFormatter;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
org.hibernate.search.util.logging.impl.Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String unableToLoadAvroSchema = "HSEARCH300001: Unable to find Avro schema '%s'";
    private static final String unexpectedMinorProtocolVersion = "HSEARCH300002: Parsing message from a future protocol version. Some feature might not be propagated. Message version: %1$d.%2$d. Current protocol version: %1$d.%3$d";
    private static final String initializedBlackholeBackend = "HSEARCH000001: initialized \"blackhole\" backend. Index changes will be prepared but discarded!";
    private static final String closedBlackholeBackend = "HSEARCH000002: closed \"blackhole\" backend.";
    private static final String incorrectMessageType = "HSEARCH000016: Incorrect message type: %1$s";
    private static final String interruptedWorkError = "HSEARCH000017: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    private static final String skippingDirectorySynchronization = "HSEARCH000018: Skipping directory synchronization, previous work still in progress: %1$s";
    private static final String unableToRemovePreviousMarket = "HSEARCH000019: Unable to remove previous marker file from source of %1$s";
    private static final String unableToCreateCurrentMarker = "HSEARCH000020: Unable to create current marker in source of %1$s";
    private static final String unableToSynchronizeSource = "HSEARCH000021: Unable to synchronize source of %1$s";
    private static final String unableToDetermineCurrentInSourceDirectory = "HSEARCH000022: Unable to determine current in source directory, will try again during the next synchronization";
    private static final String unableToCompareSourceWithDestinationDirectory = "HSEARCH000023: Unable to compare %1$s with %2$s.";
    private static final String idCannotBeExtracted = "HSEARCH000024: Unable to reindex entity on collection change, id cannot be extracted: %1$s";
    private static final String serviceProviderNotReleased = "HSEARCH000025: Service provider has been used but not released: %1$s";
    private static final String stopServiceFailed = "HSEARCH000026: Fail to properly stop service: %1$s";
    private static final String indexingEntities = "HSEARCH000027: Going to reindex %d entities";
    private static final String indexingEntitiesCompleted = "HSEARCH000028: Reindexed %1$d entities";
    private static final String indexingCompletedAndMBeanUnregistered = "HSEARCH000029: Indexing completed. Reindexed %1$d entities. Unregistering MBean from server";
    private static final String indexingDocumentsCompleted = "HSEARCH000030: %1$d documents indexed in %2$d ms";
    private static final String indexingSpeed = "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    private static final String notDeleted = "HSEARCH000032: Could not delete %1$s";
    private static final String notChangeTimestamp = "HSEARCH000033: Could not change timestamp for %1$s. Index synchronization may be slow.";
    private static final String version = "HSEARCH000034: Hibernate Search %1$s";
    private static final String couldNotCloseResource = "HSEARCH000035: Could not close resource.";
    private static final String cannotGuessTransactionStatus = "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    private static final String unableToCloseSearcherDuringQuery = "HSEARCH000037: Unable to properly close searcher during lucene query: %1$s";
    private static final String forceToUseDocumentExtraction = "HSEARCH000038: Forced to use Document extraction to workaround FieldCache bug in Lucene";
    private static final String unableToCloseSearcherInScrollableResult = "HSEARCH000039: Unable to properly close searcher in ScrollableResults";
    private static final String unexpectedValueMissingFromFieldCache = "HSEARCH000040: Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.";
    private static final String indexDirectoryNotFoundCreatingNewOne = "HSEARCH000041: Index directory not found, creating: '%1$s'";
    private static final String noCurrentMarkerInSourceDirectory = "HSEARCH000042: No current marker in source directory. Has the master being started already?";
    private static final String foundCurrentMarker = "HSEARCH000043: Found current marker in source directory - initialization succeeded";
    private static final String abstractClassesCannotInsertDocuments = "HSEARCH000044: Abstract classes cannot be indexed directly. Only concrete subclasses can be indexed. @Indexed on '%s' is superfluous and should be removed.";
    private static final String containedInPointsToProvidedId = "HSEARCH000045: @ContainedIn is pointing to an entity having @ProvidedId: %1$s. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ";
    private static final String cannotExtractValueForIdentifier = "HSEARCH000046: FieldCache was enabled on class %1$s but for this type of identifier we can't extract values from the FieldCache: cache disabled";
    private static final String unableToCloseJmsConnection = "HSEARCH000047: Unable to close JMS connection for %1$s";
    private static final String unableToRetrieveNamedAnalyzer = "HSEARCH000048: Unable to retrieve named analyzer: %1$s";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String pushedChangesOutOfTransaction = "HSEARCH000050: It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!";
    private static final String forcingReleaseIndexWriterLock = "HSEARCH000052: Going to force release of the IndexWriter lock";
    private static final String checkSizeMustBePositive = "HSEARCH000053: Chunk size must be positive: using default value.";
    private static final String readersNotProperlyClosedInReaderProvider = "HSEARCH000054: ReaderProvider contains readers not properly closed at destroy time";
    private static final String unableToCloseLuceneIndexReader = "HSEARCH000055: Unable to close Lucene IndexReader";
    private static final String unableToUnregisterExistingMBean = "HSEARCH000056: Unable to un-register existing MBean: %1$s";
    private static final String exceptionOccurred = "HSEARCH000058: %1$s";
    private static final String workerException = "HSEARCH000059: Worker raises an exception on close()";
    private static final String interruptedBatchIndexing = "HSEARCH000062: Batch indexing was interrupted";
    private static final String errorRollingBackTransaction = "HSEARCH000065: Error while rolling back transaction after %1$s";
    private static final String failedSlaveDirectoryProviderInitialization = "HSEARCH000066: Failed to initialize SlaveDirectoryProvider %1$s";
    private static final String unableToCloseLuceneDirectory = "HSEARCH000067: Unable to properly close Lucene directory %1$s";
    private static final String unableToRetrieveObjectFromMessage = "HSEARCH000068: Unable to retrieve object from message: %1$s";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String cannotOpenIndexWriterCausePreviousError = "HSEARCH000072: Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!";
    private static final String backendError = "HSEARCH000073: Error in backend";
    private static final String recommendConfiguringLuceneVersion = "HSEARCH000075: Configuration setting hibernate.search.lucene_version was not specified: using LUCENE_CURRENT.";
    private static final String cantOpenCorruptedIndex = "HSEARCH000076: Could not open Lucene index: index data is corrupted. index name: '%1$s'";
    private static final String ioExceptionOnIndex = "HSEARCH000077: An IOException happened while accessing the Lucene index '%1$s'";
    private static final String unableToShutdownAsynchronousIndexingByTimeout = "HSEARCH000078: Timed out waiting to flush all operations to the backend of index %1$s";
    private static final String serializationProtocol = "HSEARCH000079: Serialization protocol version %1$d.%2$d initialized";
    private static final String messageReceivedForUndefinedIndex = "HSEARCH000080: Received a remote message about an unknown index '%1$s': discarding message!";
    private static final String warnSuspiciousBackendDirectoryCombination = "HSEARCH000081: The index '%1$s' is using a non-recommended combination of backend and directoryProvider implementations";
    private static final String unableToSerializeLuceneWorks = "HSEARCH000083: Unable to serialize List<LuceneWork>";
    private static final String unableToReadSerializedLuceneWorks = "HSEARCH000084: Unable to read serialized List<LuceneWork>";
    private static final String attributeNotRecognizedNorSerializable = "HSEARCH000085: Attribute type is not recognized and not serializable: %1$s";
    private static final String unknownAttributeSerializedRepresentation = "HSEARCH000086: Unknown attribute serialized representation: %1$s";
    private static final String unableToReadTokenStream = "HSEARCH000087: Unable to read TokenStream";
    private static final String unableToConvertSerializableStoreToLuceneStore = "HSEARCH000090: Unable to convert serializable Store to Lucene Store: %1$s";
    private static final String unknownNumericFieldType = "HSEARCH000091: Unknown NumericField type: %1$s";
    private static final String conversionFromReaderToStringNotYetImplemented = "HSEARCH000092: Conversion from Reader to String not yet implemented";
    private static final String unknownFieldType = "HSEARCH000093: Unknown Field type: %1$s";
    private static final String cannotSerializeCustomField = "HSEARCH000094: Cannot serialize custom Fieldable '%1$s'. Must be NumericField, Field or a Serializable Fieldable implementation.";
    private static final String failToSerializeObject = "HSEARCH000095: Fail to serialize object of type %1$s";
    private static final String failToDeserializeObject = "HSEARCH000096: Fail to deserialize object";
    private static final String incompatibleProtocolVersion = "HSEARCH000098: Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d";
    private static final String unableToDeserializeAvroStream = "HSEARCH000099: Unable to deserialize Avro stream";
    private static final String cannotDeserializeOperation = "HSEARCH000100: Cannot deserialize operation %1$s, unknown operation.";
    private static final String cannotDeserializeField = "HSEARCH000101: Cannot deserialize field type %1$s, unknown field type.";
    private static final String unableToSerializeInAvro = "HSEARCH000102: Unable to serialize Lucene works in Avro";
    private static final String unableToInitializeIndexManager = "HSEARCH000103: Unable to initialize IndexManager named '%1$s'";
    private static final String ignoringBackendOptionForIndex = "HSEARCH000104: Ignoring backend option for index '%1$s', configured IndexManager requires using '%2$s' instead.";
    private static final String cannotGetResultSizeWithCriteriaAndRestriction = "HSEARCH000105: Cannot safely compute getResultSize() when a Criteria with restriction is used. Use query.list().size() or query.getResultList().size(). Criteria at stake: %1$s";
    private static final String fieldLooksBinaryButDecompressionFailed = "HSEARCH000106: Field %1$s looks like binary but couldn't be decompressed";
    private static final String requestedIndexNotDefined = "HSEARCH000107: Index names %1$s is not defined";
    private static final String shuttingDownBackend = "HSEARCH000108: Shutting down backend for IndexManager '%1$s'";
    private static final String notAnIndexedType = "HSEARCH000109: %1$s is not an indexed type";
    private static final String nullIsInvalidIndexedType = "HSEARCH000110: 'null' is not a valid indexed type";
    private static final String needAtLeastOneIndexName = "HSEARCH000111: At least one index name must be provided: can't open an IndexReader on nothing";
    private static final String needAtLeastOneIndexedEntityType = "HSEARCH000112: At least one entity type must be provided: can't open an IndexReader on nothing";
    private static final String nullIsInvalidIndexName = "HSEARCH000113: 'null' is not a valid index name";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownFullTextFilter = "HSEARCH000115: Unknown @FullTextFilter: '%1$s'";
    private static final String massIndexerUnexpectedErrorMessage = "HSEARCH000116: Unexpected error during MassIndexer operation";
    private static final String ioExceptionOnIndexWriter = "HSEARCH000117: IOException on the IndexWriter";
    private static final String exceptionDuringIndexMergeOperation = "HSEARCH000118: Exception during index Merge operation";
    private static final String optimizationSkippedStillBusy = "HSEARCH000119: Skipping optimization on index %1$s as it is already being optimized";
    private static final String inconsistentFieldConfiguration = "HSEARCH000120: There are multiple properties indexed against the same field name '%1$s.%2$s', but with different indexing settings. The behaviour is undefined.";
    private static final String forceSkipIndexOperationViaInterception = "HSEARCH000125: Interceptor enforces skip index operation %2$s on instance of class %1$s";
    private static final String forceRemoveOnIndexOperationViaInterception = "HSEARCH000126: Interceptor enforces removal of index data instead of index operation %2$s on instance of class %1$s";
    private static final String forceUpdateOnIndexOperationViaInterception = "HSEARCH000128: Interceptor enforces update of index data instead of index operation %2$s on instance of class %1$s";
    private static final String targetedFieldNotSpatial = "HSEARCH000131: The field '%1$s#%2$s' used for the spatial query is not configured as spatial field. Check the proper use of @Spatial respectively SpatialFieldBridge";
    private static final String noFieldBridgeInterfaceImplementedByClassBridge = "HSEARCH000133: @ClassBridge implementation '%1$s' should implement either org.hibernate.search.bridge.FieldBridge, org.hibernate.search.bridge.TwoWayStringBridge or org.hibernate.search.bridge.StringBridge";
    private static final String cannotInstantiateClassBridgeOfType = "HSEARCH000134: Unable to instantiate ClassBridge of type %1$s defined on %2$s";
    private static final String unableToGuessFieldBridge = "HSEARCH000135: Unable to guess FieldBridge for %2$s in %1$s";
    private static final String unableToInstantiateSpatial = "HSEARCH000136: Unable to instantiate Spatial defined on %1$s";
    private static final String noImplementationClassInFieldBridge = "HSEARCH000137: @FieldBridge with no implementation class defined in: %1$s";
    private static final String noFieldBridgeInterfaceImplementedByFieldBridge = "HSEARCH000138: @FieldBridge implementation implements none of the field bridge interfaces: %1$s in %2$s";
    private static final String unableToInstantiateFieldBridge = "HSEARCH000139: Unable to instantiate FieldBridge for %1$s of class %2$s";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String fieldBridgeNotAnInstanceof = "HSEARCH000144: FieldBridge passed in is not an instance of %1$s";
    private static final String queryWithNoTermsAfterAnalysis = "HSEARCH000146: The query string '%2$s' applied on field '%1$s' has no meaningful tokens to be matched. Validate the query input against the Analyzer applied on this field.";
    private static final String unableToDetermineClassBridge = "HSEARCH000149: Unable to determine ClassBridge for %1$s";
    private static final String unableToGetInputStreamFromBlob = "HSEARCH000150: Unable to get input stream from blob data";
    private static final String unsupportedTikaBridgeType = "HSEARCH000151: Unable to get input stream from object of type %1$s";
    private static final String fileDoesNotExist = "HSEARCH000152: File %1$s does not exist";
    private static final String fileIsADirectory = "HSEARCH000153: %1$s is a directory and not a file";
    private static final String fileIsNotReadable = "HSEARCH000154: File %1$s is not readable";
    private static final String unableToConfigureTikaBridge = "HSEARCH000155: Unable to configure %1$s";
    private static final String cannotReadFieldForClass = "HSEARCH000156: Cannot read %1$s field from a %2$s object: does getter exist and is it public ?";
    private static final String cannotExtractCoordinateFromObject = "HSEARCH000157: Class %1$s does not implement the Coordinates interface";
    private static final String cannotHaveTwoSpatialsWithDefaultOrSameName = "HSEARCH000158: Class %1$s cannot have two @Spatial using default/same name";
    private static final String cannotFindCoordinatesNorLatLongForSpatial = "HSEARCH000159: Cannot find a Coordinates interface nor @Latitude/@Longitude annotations bound to the @Spatial name '%1$s' for class %2$s. It might be a typo (or a lapse) in @Latitude.of / @Longitude.of attributes.";
    private static final String ambiguousLatitudeDefinition = "HSEARCH000160: @Latitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String ambiguousLongitudeDefinition = "HSEARCH000161: @Longitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String unableToOpenJMSConnection = "HSEARCH000162: Unable to open JMS connection on queue '%2$s' for index '%1$s'";
    private static final String unableToSendJMSWork = "HSEARCH000163: Unable to send Search work to JMS queue '%2$s' for index '%1$s'";
    private static final String jmsQueueLookupException = "HSEARCH000164: Unable to lookup Search queue '%1$s' for index '%2$s'";
    private static final String indexManagerAliasResolved = "HSEARCH000166: IndexManager factory resolved alias '%1$s' to '%2$s'.";
    private static final String duplicateDocumentIdFound = "HSEARCH000167: More than one @DocumentId specified on entity '%1$s'";
    private static final String indexManagerUsesSerializationService = "HSEARCH000168: Serialization service %2$s being used for index '%1$s'";
    private static final String fieldBridgeNotTwoWay = "HSEARCH000169: FieldBridge '%1$s' does not have a objectToString method: field '%2$s' in '%3$s' The FieldBridge must be a TwoWayFieldBridge or you have to enable the ignoreFieldBridge option when defining a Query";
    private static final String unableToParseDocument = "HSEARCH000176: Document could not be parsed";
    private static final String noDocumentIdFoundException = "HSEARCH000177: Unable to find a valid document id for entity '%1$s'";
    private static final String getNullSessionPassedToFullTextSessionCreationException = "HSEARCH000178: Unable to create a FullTextSession from a null Session";
    private static final String getNullSessionPassedToFullEntityManagerCreationException = "HSEARCH000179: Unable to create a FullTextEntityManager from a null EntityManager";
    private static final String getUnableToNarrowFieldDescriptorException = "HSEARCH000180: Unable to cast %s of type %s to %s";
    private static final String getPropertyNameCannotBeNullException = "HSEARCH000181: 'null' is not a valid property name";
    private static final String getFieldNameCannotBeNullException = "HSEARCH000182: 'null' is not a valid field name";
    private static final String massIndexerUnableToIndexInstance = "HSEARCH000183: Unable to index instance of type %s while batch indexing: %s";
    private static final String entityWithNoShard = "HSEARCH000184: Cannot define an entity with 0 shard on '%1$s'";
    private static final String assertionFailureCannotCastToWorkerBuilderContext = "HSEARCH000186: [AssertionFailure: open a bug report] SearchFactory from entityIndexBinding is not assignable to WorkerBuilderContext. Actual class is %1$s";
    private static final String getMultipleEntitiesShareIndexWithInconsistentSimilarityException = "HSEARCH000189: Multiple entities are sharing the same index but are declaring an inconsistent Similarity. When overriding default Similarity make sure that all types sharing a same index declare the same Similarity implementation. %s defines similarity %s and %s defines similarity %s";
    private static final String getNoSessionFactoryInContextException = "HSEARCH000190: Unable to start HibernateSessionFactoryServiceProvider. There is no session factory in the context. Are you sure you have Hibernate ORM enabled?";
    private static final String getInvalidShardCountException = "HSEARCH000191: The number of shards must be >= 1. %s is an illegal value.";
    private static final String getInvalidIntegerValueException = "HSEARCH000192: %s";
    private static final String idHashShardingWithSingleShard = "HSEARCH000193: Selected sharding strategy is IdHashShardingStrategy. However, there is only 1 shard configured. Have you set the 'nbr_of_shards' property?";
    private static final String getUnableToLoadShardingStrategyClassException = "HSEARCH000194: Unable to load configured class '%s' as 'sharding_strategy'";
    private static final String getMultipleServiceImplementationsException = "HSEARCH000195: Multiple service implementations detected for service '%1$s': '%2$s'";
    private static final String getNoServiceImplementationFoundException = "HSEARCH000196: No service implementations for service '%1$s' can be found";
    private static final String getUnableToCreateJGroupsBackendException = "HSEARCH000197: Unable to create JGroups backend. Are you sure you have the JGroups dependencies on the classpath?";
    private static final String getUnexpectedServiceStatusException = "HSEARCH000198: Unexpected status '%s' for service '%s'. Check for circular dependencies or unreleased resources in your services.";
    private static final String configurationPropertyCantBeEmpty = "HSEARCH000199: Configuration property '%s' should not be empty: illegal format.";
    private static final String incorrectEditDistance = "HSEARCH000201: The edit distance must be either 1 or 2";
    private static final String entityWithIdNotFound = "HSEARCH000202: Unable to find entity $1%s with id $2%s";
    private static final String noFieldCompatibleForMoreLikeThis = "HSEARCH000203: No field from %s can be used for More Like This queries. They are neither stored or including the term vectors.";
    private static final String ioExceptionOnIndexOfEntity = "HSEARCH000205: An IOException happened while accessing the Lucene indexes related to '%1$s'";
    private static final String requireTFIDFSimilarity = "HSEARCH000206: MoreLikeThis queries require a TFIDFSimilarity for entity '$1%s'";
    private static final String fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis = "HSEARCH000207: Field %s of entity %s cannot be used in a MoreLikeThis query: the term vector (preferred) or the value itself need to be stored.";
    private static final String classLoaderServiceContainedInProvidedServicesException = "HSEARCH000208: ClassLoaderService cannot be provided via SearchConfiguration#getProvidedServices. Use SearchConfiguration#getClassLoaderService!";
    private static final String serviceRequestedAfterReleasedAllWasCalled = "HSEARCH000209: It is not allowed to request further services after ServiceManager#releaseAll has been called.";
    private static final String providedServicesCannotImplementStartableOrStoppable = "HSEARCH000210: Provided service '%s' implements '%s'. Provided services are not allowed to implement either Startable or Stoppable.";
    private static final String massIndexerExceptionWhileFetchingIds = "HSEARCH000211: An exception occurred while the MassIndexer was fetching the primary identifiers list";
    private static final String massIndexerExceptionWhileTransformingIds = "HSEARCH000212: An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents";
    private static final String fieldIdCannotBeUsedInMoreLikeThis = "HSEARCH000213: Field %s of entity %s cannot be used in a MoreLikeThis query. Ids and embedded ids are excluded.";
    private static final String numericFieldCannotBeUsedInMoreLikeThis = "HSEARCH000214: Field %s of entity %s cannot be used in a MoreLikeThis query. Numeric fields are not considered for the moment.";
    private static final String multipleMatchingFieldBridges = "HSEARCH000215: Multiple matching FieldBridges found for %s of return type %s: %s";
    private static final String invalidIncludePathConfiguration = "HSEARCH000216: Found invalid @IndexedEmbedded->paths elements configured for member '%s' of class '%s'. The invalid paths are [%s]";
    private static final String invalidPropertyValue = "HSEARCH000217: Invalid value '%s' for setting '%s'. Check the documentation for allowed values.";
    private static final String unknownFieldNameForMoreLikeThisQuery = "HSEARCH000218: More like this query cannot be created, because the index does not contain a field '%s' for the type '%s";
    private static final String jmsInitialContextException = "HSEARCH000219: Could not lookup initial JNDI context for the JMS ConnectionFactory named '%s' for the index '%s";
    private static final String jmsQueueFactoryLookupException = "HSEARCH000220: Could not lookup JMS ConnectionFactory named '%1s' for the index '%2s";
    private static final String detectInfiniteTypeLoopInIndexedEmbedded = "HSEARCH000221: Circular reference. Duplicate use of %1s in root entity %2s#%3s Set the @IndexedEmbedded.depth value explicitly to fix the problem.";
    private static final String searchIntegratorNotInitialized = "HSEARCH000222: The SearchFactory was not initialized";
    private static final String searchFactoryReferenceServiceNotFound = "HSEARCH000223: The Service org.hibernate.search.hcore.impl.SearchFactoryReference was not found in the Hibernate ORM Service Registry. This might be caused by the Hibernate ORM classloader not having visibility on Hibernate Search";
    private static final String parametersShouldNotBeNull = "HSEARCH000224: Non optional parameter named '%s' was null";
    private static final String lockingFailureDuringInitialization = "HSEARCH000225: An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.";
    private static final String logInfoStreamMessage = "HSEARCH000226: %s: %s";
    private static final String booleanQueryWithoutClauses = "HSEARCH000227: A BooleanQuery is not valid without at least one clause. Use at least one of should(Query) or must(Query).";
    private static final String illegalLuceneVersionFormat = "HSEARCH000228: Property hibernate.search.lucene_version set to value '%s' is not in a valid format to express a Lucene version: %s";
    private static final String flushIntervalNeedsToBePositive = "HSEARCH000229: Property index_flush_intervalfor the index '%s' needs to be positive.";
    private static final String startingSyncConsumerThread = "HSEARCH000230: Starting sync consumer thread for index '%s'";
    private static final String stoppingSyncConsumerThread = "HSEARCH000231: Stopping sync consumer thread for index '%s'";
    private static final String stringEncodedFieldsAreTargetedWithNumericQuery = "HSEARCH000232: The specified query '%s' contains a numeric sub query which targets the string encoded field(s) '%s'. Check your query or try limiting the targeted entities.";
    private static final String numericEncodedFieldsAreTargetedWithStringQuery = "HSEARCH000233: The specified query '%s' contains a string based sub query which targets the numeric encoded field(s) '%s'. Check your query or try limiting the targeted entities.";
    private static final String targetedEntityTypesNotIndexed = "HSEARCH000234: None of the specified entity types ('%s') or any of their subclasses are indexed.";
    private static final String luceneBackendInitializedSynchronously = "HSEARCH000235: Backend for index '%s' started: using a Synchronous batching backend.";
    private static final String luceneBackendInitializedAsynchronously = "HSEARCH000236: Backend for index '%s' started: using an Asynchronous backend with periodic commits.";
    private static final String rangeQueryWithNullToAndFromValue = "HSEARCH000237: Cannot create numeric range query for field '%s', since from and to values are null";
    private static final String numericRangeQueryWithNonNumericToAndFromValues = "HSEARCH000238: Cannot create numeric range query for field '%s', since values are not numeric (Date, int, long, short or double)";
    private static final String unknownEncodingType = "HSEARCH000239: Unknown field encoding type: %1$s";
    private static final String invalidStringDateFieldInDocument = "HSEARCH000240: Unable to parse value '%2$s' of field '%1$s' into a Date";
    private static final String multipleFactoryMethodsInClass = "HSEARCH000241: Multiple @Factory methods defined in %s";
    private static final String noPublicNoArgConstructor = "HSEARCH000242: Search requires '%s' to have a public no-arg constructor in order to instantiate it";
    private static final String unableToAccessClass = "HSEARCH000243: Unable to access class '%s'";
    private static final String factoryMethodsMustReturnAnObject = "HSEARCH000244: Factory methods must return an object. '%1$s#%2$s' does not";
    private static final String unableToAccessMethod = "HSEARCH000245: Unable to access method '%1$s#%2$s'";
    private static final String exceptionDuringFactoryMethodExecution = "HSEARCH000246: An exception occurred while invoking '%1$s#%2$s'";
    private static final String fieldTriesToOverrideIdFieldSettings = "HSEARCH000247: An indexed field defined on '%1$s:%2$s' tries to override the id field settings. The document id field settings cannot be modified. Use a different field name.";
    private static final String workListShouldNeverBeEmpty = "HSEARCH000248: WorkList should never be empty. Stacktrace below \n %s";
    private static final String singleTermDeleteDisabled = "HSEARCH000249: Cannot do fast deletes on index '%s'. Entities in this index are conflicting or the index can accept unknown entities.";
    private static final String unsupportedErrorHandlerConfigurationValueType = "HSEARCH000250: Unsupported value type for configuration property hibernate.search.error_handler: %1$s";
    private static final String unableToSetFilterParameter = "HSEARCH000251: Unable to set filter parameter '%2$s' on filter class %1$s";
    private static final String cannotInitializeDirectoryProvider = "HSEARCH000252: Unable to initialize directory provider %1$s for index %2$s";
    private static final String indexBasePathRequiredForLockingStrategy = "HSEARCH000253: To use '%1$s' as a locking strategy, an indexBase path must be set";
    private static final String unknownIndexingMode = "HSEARCH000254: Unknown indexing mode: %1$s";
    private static final String unknownDocValuesTypeType = "HSEARCH000255: Unknown DocValues type: %1$s";
    private static final String unexpectedBinaryDocValuesTypeType = "HSEARCH000256: '%1$s' is an unexpected type for a binary doc value";
    private static final String unexpectedNumericDocValuesTypeType = "HSEARCH000257: '%1$s' is an unexpected type for a numeric doc value";
    private static final String loadingNonExistentField = "HSEARCH000258: Attempting to load a field named '%s' from the Lucene Document. This Document instance doesn't have such a field.";
    private static final String unableToDeleteByQuery = "HSEARCH000259: Unable to delete all %s matching Query: %s";
    private static final String givenCriteriaObjectCannotBeApplied = "HSEARCH000260: A criteria for loading query results has been specified via FullTextQuery#setCriteriaQuery(), but query results originate from several id spaces. The given criteria object can therefore not be be applied.";
    private static final String unknownDeletionQueryKeySpecified = "HSEARCH000261: An unknown DeletionQuery key was specified during de-serialization of a message from another node: %d";
    private static final String numericFieldAnnotationWithoutMatchingField = "HSEARCH000262: @NumericField annotation is used on %1$s#%2$s without a matching @Field annotation";
    private static final String facetAnnotationWithoutMatchingField = "HSEARCH000263: @Facet annotation is used on %1$s#%2$s without a matching @Field annotation";
    private static final String unsupportedFieldTypeForFaceting = "HSEARCH000264: @Facet is not supported for type '%1$s'. See %2$s#%3$s";
    private static final String errorDuringFacetingIndexing = "HSEARCH000265: Unable to build Lucene Document due to facet indexing error";
    private static final String unsupportedFacetRangeParameter = "HSEARCH000266: '%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported";
    private static final String numericDateFacetForNonNumericField = "HSEARCH000267: Unable to index date facet '%1$s' for field '%2$s', since the matching field is not using a numeric field bridge";
    private static final String unknownFieldNameForFaceting = "HSEARCH000268: Facet request '%1$s' tries to facet on  field '%2$s' which either does not exists or is not configured for faceting (via @Facet). Check your configuration.";
    private static final String unsupportedParameterTypeForRangeFaceting = "HSEARCH000269: '%1$s' is not a supported type for a range faceting request parameter. Supported types are: '%2$s'";
    private static final String noStartOrEndSpecifiedForRangeQuery = "HSEARCH000270: At least of of the facets ranges in facet request '%1$s' contains neither start nor end value";
    private static final String rangeDefinitionOrderRequestedForDiscrteFacetRequest = "HSEARCH000271: RANGE_DEFINITION_ORDER is not a valid sort order for a discrete faceting request.";
    private static final String attemptToCreateFacetingRequestForUnindexedEntity = "HSEARCH000272: Entity '%1$s' is not an indexed entity. Unable to create faceting request";
    private static final String attemptToFacetOnAnalyzedField = "HSEARCH000273: The indexed field '%1$s' in '%2$s' is analyzed and marked for faceting. Only un-analyzed fields can be faceted.";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final SearchException unableToLoadAvroSchema(String avroSchemaFile) {
        SearchException result = new SearchException(String.format(this.unableToLoadAvroSchema$str(), avroSchemaFile));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadAvroSchema$str() {
        return unableToLoadAvroSchema;
    }

    @Override
    public final void unexpectedMinorProtocolVersion(int majorVersion, int minorVersion, int latestKnownMinor) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.unexpectedMinorProtocolVersion$str(), (Object)majorVersion, (Object)minorVersion, (Object)latestKnownMinor);
    }

    protected String unexpectedMinorProtocolVersion$str() {
        return unexpectedMinorProtocolVersion;
    }

    @Override
    public final void initializedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.initializedBlackholeBackend$str(), new Object[0]);
    }

    protected String initializedBlackholeBackend$str() {
        return initializedBlackholeBackend;
    }

    @Override
    public final void closedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.closedBlackholeBackend$str(), new Object[0]);
    }

    protected String closedBlackholeBackend$str() {
        return closedBlackholeBackend;
    }

    public final void incorrectMessageType(Class arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.incorrectMessageType$str(), (Object)new ClassFormatter(arg0));
    }

    protected String incorrectMessageType$str() {
        return incorrectMessageType;
    }

    @Override
    public final void interruptedWorkError(Runnable arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.interruptedWorkError$str(), (Object)arg0);
    }

    protected String interruptedWorkError$str() {
        return interruptedWorkError;
    }

    @Override
    public final void skippingDirectorySynchronization(String arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.skippingDirectorySynchronization$str(), (Object)arg0);
    }

    protected String skippingDirectorySynchronization$str() {
        return skippingDirectorySynchronization;
    }

    @Override
    public final void unableToRemovePreviousMarket(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToRemovePreviousMarket$str(), (Object)arg0);
    }

    protected String unableToRemovePreviousMarket$str() {
        return unableToRemovePreviousMarket;
    }

    @Override
    public final void unableToCreateCurrentMarker(String arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.unableToCreateCurrentMarker$str(), (Object)arg0);
    }

    protected String unableToCreateCurrentMarker$str() {
        return unableToCreateCurrentMarker;
    }

    @Override
    public final void unableToSynchronizeSource(String arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg1, this.unableToSynchronizeSource$str(), (Object)arg0);
    }

    protected String unableToSynchronizeSource$str() {
        return unableToSynchronizeSource;
    }

    @Override
    public final void unableToDetermineCurrentInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToDetermineCurrentInSourceDirectory$str(), new Object[0]);
    }

    protected String unableToDetermineCurrentInSourceDirectory$str() {
        return unableToDetermineCurrentInSourceDirectory;
    }

    @Override
    public final void unableToCompareSourceWithDestinationDirectory(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.unableToCompareSourceWithDestinationDirectory$str(), (Object)arg0, (Object)arg1);
    }

    protected String unableToCompareSourceWithDestinationDirectory$str() {
        return unableToCompareSourceWithDestinationDirectory;
    }

    @Override
    public final void idCannotBeExtracted(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.idCannotBeExtracted$str(), (Object)arg0);
    }

    protected String idCannotBeExtracted$str() {
        return idCannotBeExtracted;
    }

    public final void serviceProviderNotReleased(Class arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.serviceProviderNotReleased$str(), (Object)new ClassFormatter(arg0));
    }

    protected String serviceProviderNotReleased$str() {
        return serviceProviderNotReleased;
    }

    public final void stopServiceFailed(Class arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg1, this.stopServiceFailed$str(), (Object)new ClassFormatter(arg0));
    }

    protected String stopServiceFailed$str() {
        return stopServiceFailed;
    }

    @Override
    public final void indexingEntities(long arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.indexingEntities$str(), (Object)arg0);
    }

    protected String indexingEntities$str() {
        return indexingEntities;
    }

    @Override
    public final void indexingEntitiesCompleted(long arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.indexingEntitiesCompleted$str(), (Object)arg0);
    }

    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }

    @Override
    public final void indexingCompletedAndMBeanUnregistered(long arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.indexingCompletedAndMBeanUnregistered$str(), (Object)arg0);
    }

    protected String indexingCompletedAndMBeanUnregistered$str() {
        return indexingCompletedAndMBeanUnregistered;
    }

    @Override
    public final void indexingDocumentsCompleted(long arg0, long arg1) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.indexingDocumentsCompleted$str(), (Object)arg0, (Object)arg1);
    }

    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }

    @Override
    public final void indexingSpeed(float arg0, float arg1) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.indexingSpeed$str(), (Object)Float.valueOf(arg0), (Object)Float.valueOf(arg1));
    }

    protected String indexingSpeed$str() {
        return indexingSpeed;
    }

    @Override
    public final void notDeleted(File arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.notDeleted$str(), (Object)arg0);
    }

    protected String notDeleted$str() {
        return notDeleted;
    }

    @Override
    public final void notChangeTimestamp(File arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.notChangeTimestamp$str(), (Object)arg0);
    }

    protected String notChangeTimestamp$str() {
        return notChangeTimestamp;
    }

    @Override
    public final void version(String arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.version$str(), (Object)arg0);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final void couldNotCloseResource(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg0, this.couldNotCloseResource$str(), new Object[0]);
    }

    protected String couldNotCloseResource$str() {
        return couldNotCloseResource;
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg0, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return cannotGuessTransactionStatus;
    }

    @Override
    public final void unableToCloseSearcherDuringQuery(String arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.unableToCloseSearcherDuringQuery$str(), (Object)arg0);
    }

    protected String unableToCloseSearcherDuringQuery$str() {
        return unableToCloseSearcherDuringQuery;
    }

    @Override
    public final void forceToUseDocumentExtraction() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.forceToUseDocumentExtraction$str(), new Object[0]);
    }

    protected String forceToUseDocumentExtraction$str() {
        return forceToUseDocumentExtraction;
    }

    @Override
    public final void unableToCloseSearcherInScrollableResult(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg0, this.unableToCloseSearcherInScrollableResult$str(), new Object[0]);
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return unableToCloseSearcherInScrollableResult;
    }

    @Override
    public final void unexpectedValueMissingFromFieldCache() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.unexpectedValueMissingFromFieldCache$str(), new Object[0]);
    }

    protected String unexpectedValueMissingFromFieldCache$str() {
        return unexpectedValueMissingFromFieldCache;
    }

    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(String arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.indexDirectoryNotFoundCreatingNewOne$str(), (Object)arg0);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return indexDirectoryNotFoundCreatingNewOne;
    }

    @Override
    public final void noCurrentMarkerInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.noCurrentMarkerInSourceDirectory$str(), new Object[0]);
    }

    protected String noCurrentMarkerInSourceDirectory$str() {
        return noCurrentMarkerInSourceDirectory;
    }

    @Override
    public final void foundCurrentMarker() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.foundCurrentMarker$str(), new Object[0]);
    }

    protected String foundCurrentMarker$str() {
        return foundCurrentMarker;
    }

    @Override
    public final void abstractClassesCannotInsertDocuments(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.abstractClassesCannotInsertDocuments$str(), (Object)arg0);
    }

    protected String abstractClassesCannotInsertDocuments$str() {
        return abstractClassesCannotInsertDocuments;
    }

    public final void containedInPointsToProvidedId(Class arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.containedInPointsToProvidedId$str(), (Object)new ClassFormatter(arg0));
    }

    protected String containedInPointsToProvidedId$str() {
        return containedInPointsToProvidedId;
    }

    public final void cannotExtractValueForIdentifier(Class arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotExtractValueForIdentifier$str(), (Object)new ClassFormatter(arg0));
    }

    protected String cannotExtractValueForIdentifier$str() {
        return cannotExtractValueForIdentifier;
    }

    @Override
    public final void unableToCloseJmsConnection(String arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.unableToCloseJmsConnection$str(), (Object)arg0);
    }

    protected String unableToCloseJmsConnection$str() {
        return unableToCloseJmsConnection;
    }

    @Override
    public final void unableToRetrieveNamedAnalyzer(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToRetrieveNamedAnalyzer$str(), (Object)arg0);
    }

    protected String unableToRetrieveNamedAnalyzer$str() {
        return unableToRetrieveNamedAnalyzer;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(InterruptedException arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg0, this.interruptedWhileWaitingForIndexActivity$str(), new Object[0]);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    @Override
    public final void pushedChangesOutOfTransaction() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.pushedChangesOutOfTransaction$str(), new Object[0]);
    }

    protected String pushedChangesOutOfTransaction$str() {
        return pushedChangesOutOfTransaction;
    }

    @Override
    public final void forcingReleaseIndexWriterLock() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.forcingReleaseIndexWriterLock$str(), new Object[0]);
    }

    protected String forcingReleaseIndexWriterLock$str() {
        return forcingReleaseIndexWriterLock;
    }

    @Override
    public final void checkSizeMustBePositive() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.checkSizeMustBePositive$str(), new Object[0]);
    }

    protected String checkSizeMustBePositive$str() {
        return checkSizeMustBePositive;
    }

    @Override
    public final void readersNotProperlyClosedInReaderProvider() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.readersNotProperlyClosedInReaderProvider$str(), new Object[0]);
    }

    protected String readersNotProperlyClosedInReaderProvider$str() {
        return readersNotProperlyClosedInReaderProvider;
    }

    @Override
    public final void unableToCloseLuceneIndexReader(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg0, this.unableToCloseLuceneIndexReader$str(), new Object[0]);
    }

    protected String unableToCloseLuceneIndexReader$str() {
        return unableToCloseLuceneIndexReader;
    }

    @Override
    public final void unableToUnregisterExistingMBean(String arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.unableToUnregisterExistingMBean$str(), (Object)arg0);
    }

    protected String unableToUnregisterExistingMBean$str() {
        return unableToUnregisterExistingMBean;
    }

    @Override
    public final void exceptionOccurred(String arg0, Throwable arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, arg1, this.exceptionOccurred$str(), (Object)arg0);
    }

    protected String exceptionOccurred$str() {
        return exceptionOccurred;
    }

    @Override
    public final void workerException(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.workerException$str(), new Object[0]);
    }

    protected String workerException$str() {
        return workerException;
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    @Override
    public final void errorRollingBackTransaction(String arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg1, this.errorRollingBackTransaction$str(), (Object)arg0);
    }

    protected String errorRollingBackTransaction$str() {
        return errorRollingBackTransaction;
    }

    @Override
    public final void failedSlaveDirectoryProviderInitialization(String arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg1, this.failedSlaveDirectoryProviderInitialization$str(), (Object)arg0);
    }

    protected String failedSlaveDirectoryProviderInitialization$str() {
        return failedSlaveDirectoryProviderInitialization;
    }

    @Override
    public final void unableToCloseLuceneDirectory(Object arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg1, this.unableToCloseLuceneDirectory$str(), arg0);
    }

    protected String unableToCloseLuceneDirectory$str() {
        return unableToCloseLuceneDirectory;
    }

    public final void unableToRetrieveObjectFromMessage(Class arg0, Exception arg1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg1, this.unableToRetrieveObjectFromMessage$str(), (Object)new ClassFormatter(arg0));
    }

    protected String unableToRetrieveObjectFromMessage$str() {
        return unableToRetrieveObjectFromMessage;
    }

    @Override
    public final void illegalObjectRetrievedFromMessage(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    @Override
    public final void cannotOpenIndexWriterCausePreviousError() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.cannotOpenIndexWriterCausePreviousError$str(), new Object[0]);
    }

    protected String cannotOpenIndexWriterCausePreviousError$str() {
        return cannotOpenIndexWriterCausePreviousError;
    }

    @Override
    public final void backendError(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.backendError$str(), new Object[0]);
    }

    protected String backendError$str() {
        return backendError;
    }

    @Override
    public final void recommendConfiguringLuceneVersion() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.recommendConfiguringLuceneVersion$str(), new Object[0]);
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return recommendConfiguringLuceneVersion;
    }

    @Override
    public final SearchException cantOpenCorruptedIndex(CorruptIndexException arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.cantOpenCorruptedIndex$str(), arg1), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cantOpenCorruptedIndex$str() {
        return cantOpenCorruptedIndex;
    }

    @Override
    public final SearchException ioExceptionOnIndex(IOException arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.ioExceptionOnIndex$str(), arg1), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndex$str() {
        return ioExceptionOnIndex;
    }

    @Override
    public final void unableToShutdownAsynchronousIndexingByTimeout(String arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.unableToShutdownAsynchronousIndexingByTimeout$str(), (Object)arg0);
    }

    protected String unableToShutdownAsynchronousIndexingByTimeout$str() {
        return unableToShutdownAsynchronousIndexingByTimeout;
    }

    @Override
    public final void serializationProtocol(int arg0, int arg1) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.serializationProtocol$str(), (Object)arg0, (Object)arg1);
    }

    protected String serializationProtocol$str() {
        return serializationProtocol;
    }

    @Override
    public final void messageReceivedForUndefinedIndex(String arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.messageReceivedForUndefinedIndex$str(), (Object)arg0);
    }

    protected String messageReceivedForUndefinedIndex$str() {
        return messageReceivedForUndefinedIndex;
    }

    @Override
    public final void warnSuspiciousBackendDirectoryCombination(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnSuspiciousBackendDirectoryCombination$str(), (Object)arg0);
    }

    protected String warnSuspiciousBackendDirectoryCombination$str() {
        return warnSuspiciousBackendDirectoryCombination;
    }

    @Override
    public final SearchException unableToSerializeLuceneWorks(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.unableToSerializeLuceneWorks$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeLuceneWorks$str() {
        return unableToSerializeLuceneWorks;
    }

    @Override
    public final SearchException unableToReadSerializedLuceneWorks(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.unableToReadSerializedLuceneWorks$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadSerializedLuceneWorks$str() {
        return unableToReadSerializedLuceneWorks;
    }

    public final SearchException attributeNotRecognizedNorSerializable(Class arg0) {
        SearchException result = new SearchException(String.format(this.attributeNotRecognizedNorSerializable$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeNotRecognizedNorSerializable$str() {
        return attributeNotRecognizedNorSerializable;
    }

    @Override
    public final SearchException unknownAttributeSerializedRepresentation(String arg0) {
        SearchException result = new SearchException(String.format(this.unknownAttributeSerializedRepresentation$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAttributeSerializedRepresentation$str() {
        return unknownAttributeSerializedRepresentation;
    }

    @Override
    public final SearchException unableToReadTokenStream() {
        SearchException result = new SearchException(String.format(this.unableToReadTokenStream$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadTokenStream$str() {
        return unableToReadTokenStream;
    }

    @Override
    public final SearchException unableToConvertSerializableStoreToLuceneStore(String arg0) {
        SearchException result = new SearchException(String.format(this.unableToConvertSerializableStoreToLuceneStore$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableStoreToLuceneStore$str() {
        return unableToConvertSerializableStoreToLuceneStore;
    }

    @Override
    public final SearchException unknownNumericFieldType(String arg0) {
        SearchException result = new SearchException(String.format(this.unknownNumericFieldType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownNumericFieldType$str() {
        return unknownNumericFieldType;
    }

    @Override
    public final SearchException conversionFromReaderToStringNotYetImplemented() {
        SearchException result = new SearchException(String.format(this.conversionFromReaderToStringNotYetImplemented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conversionFromReaderToStringNotYetImplemented$str() {
        return conversionFromReaderToStringNotYetImplemented;
    }

    public final SearchException unknownFieldType(Class arg0) {
        SearchException result = new SearchException(String.format(this.unknownFieldType$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldType$str() {
        return unknownFieldType;
    }

    public final SearchException cannotSerializeCustomField(Class arg0) {
        SearchException result = new SearchException(String.format(this.cannotSerializeCustomField$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSerializeCustomField$str() {
        return cannotSerializeCustomField;
    }

    public final SearchException failToSerializeObject(Class arg0, Throwable arg1) {
        SearchException result = new SearchException(String.format(this.failToSerializeObject$str(), new ClassFormatter(arg0)), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToSerializeObject$str() {
        return failToSerializeObject;
    }

    @Override
    public final SearchException failToDeserializeObject(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.failToDeserializeObject$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToDeserializeObject$str() {
        return failToDeserializeObject;
    }

    @Override
    public final SearchException incompatibleProtocolVersion(int arg0, int arg1, int arg2, int arg3) {
        SearchException result = new SearchException(String.format(this.incompatibleProtocolVersion$str(), arg0, arg1, arg2, arg3));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleProtocolVersion$str() {
        return incompatibleProtocolVersion;
    }

    @Override
    public final SearchException unableToDeserializeAvroStream(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.unableToDeserializeAvroStream$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeserializeAvroStream$str() {
        return unableToDeserializeAvroStream;
    }

    @Override
    public final SearchException cannotDeserializeOperation(String arg0) {
        SearchException result = new SearchException(String.format(this.cannotDeserializeOperation$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeOperation$str() {
        return cannotDeserializeOperation;
    }

    @Override
    public final SearchException cannotDeserializeField(String arg0) {
        SearchException result = new SearchException(String.format(this.cannotDeserializeField$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeField$str() {
        return cannotDeserializeField;
    }

    @Override
    public final SearchException unableToSerializeInAvro(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.unableToSerializeInAvro$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeInAvro$str() {
        return unableToSerializeInAvro;
    }

    @Override
    public final SearchException unableToInitializeIndexManager(String arg0, Throwable arg1) {
        SearchException result = new SearchException(String.format(this.unableToInitializeIndexManager$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeIndexManager$str() {
        return unableToInitializeIndexManager;
    }

    @Override
    public final void ignoringBackendOptionForIndex(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.ignoringBackendOptionForIndex$str(), (Object)arg0, (Object)arg1);
    }

    protected String ignoringBackendOptionForIndex$str() {
        return ignoringBackendOptionForIndex;
    }

    @Override
    public final SearchException cannotGetResultSizeWithCriteriaAndRestriction(String arg0) {
        SearchException result = new SearchException(String.format(this.cannotGetResultSizeWithCriteriaAndRestriction$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGetResultSizeWithCriteriaAndRestriction$str() {
        return cannotGetResultSizeWithCriteriaAndRestriction;
    }

    @Override
    public final SearchException fieldLooksBinaryButDecompressionFailed(String arg0) {
        SearchException result = new SearchException(String.format(this.fieldLooksBinaryButDecompressionFailed$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldLooksBinaryButDecompressionFailed$str() {
        return fieldLooksBinaryButDecompressionFailed;
    }

    @Override
    public final SearchException requestedIndexNotDefined(String arg0) {
        SearchException result = new SearchException(String.format(this.requestedIndexNotDefined$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestedIndexNotDefined$str() {
        return requestedIndexNotDefined;
    }

    @Override
    public final void shuttingDownBackend(String arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.shuttingDownBackend$str(), (Object)arg0);
    }

    protected String shuttingDownBackend$str() {
        return shuttingDownBackend;
    }

    @Override
    public final IllegalArgumentException notAnIndexedType(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.notAnIndexedType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAnIndexedType$str() {
        return notAnIndexedType;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexedType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullIsInvalidIndexedType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexedType$str() {
        return nullIsInvalidIndexedType;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.needAtLeastOneIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexName$str() {
        return needAtLeastOneIndexName;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexedEntityType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.needAtLeastOneIndexedEntityType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexedEntityType$str() {
        return needAtLeastOneIndexedEntityType;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullIsInvalidIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexName$str() {
        return nullIsInvalidIndexName;
    }

    @Override
    public final SearchException unableToLoadResource(String arg0) {
        SearchException result = new SearchException(String.format(this.unableToLoadResource$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    @Override
    public final SearchException unknownFullTextFilter(String arg0) {
        SearchException result = new SearchException(String.format(this.unknownFullTextFilter$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFullTextFilter$str() {
        return unknownFullTextFilter;
    }

    @Override
    public final String massIndexerUnexpectedErrorMessage() {
        String result = String.format(this.massIndexerUnexpectedErrorMessage$str(), new Object[0]);
        return result;
    }

    protected String massIndexerUnexpectedErrorMessage$str() {
        return massIndexerUnexpectedErrorMessage;
    }

    @Override
    public final String ioExceptionOnIndexWriter() {
        String result = String.format(this.ioExceptionOnIndexWriter$str(), new Object[0]);
        return result;
    }

    protected String ioExceptionOnIndexWriter$str() {
        return ioExceptionOnIndexWriter;
    }

    @Override
    public final String exceptionDuringIndexMergeOperation() {
        String result = String.format(this.exceptionDuringIndexMergeOperation$str(), new Object[0]);
        return result;
    }

    protected String exceptionDuringIndexMergeOperation$str() {
        return exceptionDuringIndexMergeOperation;
    }

    @Override
    public final void optimizationSkippedStillBusy(String arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.optimizationSkippedStillBusy$str(), (Object)arg0);
    }

    protected String optimizationSkippedStillBusy$str() {
        return optimizationSkippedStillBusy;
    }

    @Override
    public final void inconsistentFieldConfiguration(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.inconsistentFieldConfiguration$str(), (Object)arg0, (Object)arg1);
    }

    protected String inconsistentFieldConfiguration$str() {
        return inconsistentFieldConfiguration;
    }

    public final void forceSkipIndexOperationViaInterception(Class arg0, WorkType arg1) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.forceSkipIndexOperationViaInterception$str(), (Object)new ClassFormatter(arg0), (Object)arg1);
    }

    protected String forceSkipIndexOperationViaInterception$str() {
        return forceSkipIndexOperationViaInterception;
    }

    public final void forceRemoveOnIndexOperationViaInterception(Class arg0, WorkType arg1) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.forceRemoveOnIndexOperationViaInterception$str(), (Object)new ClassFormatter(arg0), (Object)arg1);
    }

    protected String forceRemoveOnIndexOperationViaInterception$str() {
        return forceRemoveOnIndexOperationViaInterception;
    }

    public final void forceUpdateOnIndexOperationViaInterception(Class arg0, WorkType arg1) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.forceUpdateOnIndexOperationViaInterception$str(), (Object)new ClassFormatter(arg0), (Object)arg1);
    }

    protected String forceUpdateOnIndexOperationViaInterception$str() {
        return forceUpdateOnIndexOperationViaInterception;
    }

    @Override
    public final SearchException targetedFieldNotSpatial(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.targetedFieldNotSpatial$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetedFieldNotSpatial$str() {
        return targetedFieldNotSpatial;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByClassBridge(String arg0) {
        SearchException result = new SearchException(String.format(this.noFieldBridgeInterfaceImplementedByClassBridge$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByClassBridge$str() {
        return noFieldBridgeInterfaceImplementedByClassBridge;
    }

    @Override
    public final SearchException cannotInstantiateClassBridgeOfType(String arg0, String arg1, Throwable arg2) {
        SearchException result = new SearchException(String.format(this.cannotInstantiateClassBridgeOfType$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateClassBridgeOfType$str() {
        return cannotInstantiateClassBridgeOfType;
    }

    @Override
    public final SearchException unableToGuessFieldBridge(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.unableToGuessFieldBridge$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGuessFieldBridge$str() {
        return unableToGuessFieldBridge;
    }

    @Override
    public final SearchException unableToInstantiateSpatial(String arg0, Throwable arg1) {
        SearchException result = new SearchException(String.format(this.unableToInstantiateSpatial$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateSpatial$str() {
        return unableToInstantiateSpatial;
    }

    @Override
    public final SearchException noImplementationClassInFieldBridge(String arg0) {
        SearchException result = new SearchException(String.format(this.noImplementationClassInFieldBridge$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noImplementationClassInFieldBridge$str() {
        return noImplementationClassInFieldBridge;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByFieldBridge(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.noFieldBridgeInterfaceImplementedByFieldBridge$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByFieldBridge$str() {
        return noFieldBridgeInterfaceImplementedByFieldBridge;
    }

    @Override
    public final SearchException unableToInstantiateFieldBridge(String arg0, String arg1, Throwable arg2) {
        SearchException result = new SearchException(String.format(this.unableToInstantiateFieldBridge$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateFieldBridge$str() {
        return unableToInstantiateFieldBridge;
    }

    @Override
    public final AssertionFailure unknownResolution(String arg0) {
        AssertionFailure result = new AssertionFailure(String.format(this.unknownResolution$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    @Override
    public final SearchException fieldBridgeNotAnInstanceof(String arg0) {
        SearchException result = new SearchException(String.format(this.fieldBridgeNotAnInstanceof$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotAnInstanceof$str() {
        return fieldBridgeNotAnInstanceof;
    }

    @Override
    public final EmptyQueryException queryWithNoTermsAfterAnalysis(String arg0, String arg1) {
        EmptyQueryException result = new EmptyQueryException(String.format(this.queryWithNoTermsAfterAnalysis$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryWithNoTermsAfterAnalysis$str() {
        return queryWithNoTermsAfterAnalysis;
    }

    @Override
    public final SearchException unableToDetermineClassBridge(String arg0) {
        SearchException result = new SearchException(String.format(this.unableToDetermineClassBridge$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineClassBridge$str() {
        return unableToDetermineClassBridge;
    }

    @Override
    public final SearchException unableToGetInputStreamFromBlob(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.unableToGetInputStreamFromBlob$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGetInputStreamFromBlob$str() {
        return unableToGetInputStreamFromBlob;
    }

    public final SearchException unsupportedTikaBridgeType(Class arg0) {
        SearchException result = new SearchException(String.format(this.unsupportedTikaBridgeType$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedTikaBridgeType$str() {
        return unsupportedTikaBridgeType;
    }

    @Override
    public final SearchException fileDoesNotExist(String arg0) {
        SearchException result = new SearchException(String.format(this.fileDoesNotExist$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileDoesNotExist$str() {
        return fileDoesNotExist;
    }

    @Override
    public final SearchException fileIsADirectory(String arg0) {
        SearchException result = new SearchException(String.format(this.fileIsADirectory$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsADirectory$str() {
        return fileIsADirectory;
    }

    @Override
    public final SearchException fileIsNotReadable(String arg0) {
        SearchException result = new SearchException(String.format(this.fileIsNotReadable$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsNotReadable$str() {
        return fileIsNotReadable;
    }

    @Override
    public final SearchException unableToConfigureTikaBridge(String arg0, Throwable arg1) {
        SearchException result = new SearchException(String.format(this.unableToConfigureTikaBridge$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureTikaBridge$str() {
        return unableToConfigureTikaBridge;
    }

    @Override
    public final SearchException cannotReadFieldForClass(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.cannotReadFieldForClass$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReadFieldForClass$str() {
        return cannotReadFieldForClass;
    }

    @Override
    public final SearchException cannotExtractCoordinateFromObject(String arg0) {
        SearchException result = new SearchException(String.format(this.cannotExtractCoordinateFromObject$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExtractCoordinateFromObject$str() {
        return cannotExtractCoordinateFromObject;
    }

    @Override
    public final SearchException cannotHaveTwoSpatialsWithDefaultOrSameName(String arg0) {
        SearchException result = new SearchException(String.format(this.cannotHaveTwoSpatialsWithDefaultOrSameName$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotHaveTwoSpatialsWithDefaultOrSameName$str() {
        return cannotHaveTwoSpatialsWithDefaultOrSameName;
    }

    @Override
    public final SearchException cannotFindCoordinatesNorLatLongForSpatial(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.cannotFindCoordinatesNorLatLongForSpatial$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindCoordinatesNorLatLongForSpatial$str() {
        return cannotFindCoordinatesNorLatLongForSpatial;
    }

    @Override
    public final SearchException ambiguousLatitudeDefinition(String arg0, String arg1, String arg2) {
        SearchException result = new SearchException(String.format(this.ambiguousLatitudeDefinition$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLatitudeDefinition$str() {
        return ambiguousLatitudeDefinition;
    }

    @Override
    public final SearchException ambiguousLongitudeDefinition(String arg0, String arg1, String arg2) {
        SearchException result = new SearchException(String.format(this.ambiguousLongitudeDefinition$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLongitudeDefinition$str() {
        return ambiguousLongitudeDefinition;
    }

    @Override
    public final SearchException unableToOpenJMSConnection(String arg0, String arg1, Throwable arg2) {
        SearchException result = new SearchException(String.format(this.unableToOpenJMSConnection$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToOpenJMSConnection$str() {
        return unableToOpenJMSConnection;
    }

    @Override
    public final SearchException unableToSendJMSWork(String arg0, String arg1, Throwable arg2) {
        SearchException result = new SearchException(String.format(this.unableToSendJMSWork$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendJMSWork$str() {
        return unableToSendJMSWork;
    }

    @Override
    public final SearchException jmsQueueLookupException(String arg0, String arg1, Throwable arg2) {
        SearchException result = new SearchException(String.format(this.jmsQueueLookupException$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsQueueLookupException$str() {
        return jmsQueueLookupException;
    }

    @Override
    public final void indexManagerAliasResolved(String arg0, Class arg1) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.indexManagerAliasResolved$str(), (Object)arg0, (Object)arg1);
    }

    protected String indexManagerAliasResolved$str() {
        return indexManagerAliasResolved;
    }

    @Override
    public final SearchException duplicateDocumentIdFound(String arg0) {
        SearchException result = new SearchException(String.format(this.duplicateDocumentIdFound$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateDocumentIdFound$str() {
        return duplicateDocumentIdFound;
    }

    @Override
    public final void indexManagerUsesSerializationService(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.indexManagerUsesSerializationService$str(), (Object)arg0, (Object)arg1);
    }

    protected String indexManagerUsesSerializationService$str() {
        return indexManagerUsesSerializationService;
    }

    public final SearchException fieldBridgeNotTwoWay(Class arg0, String arg1, XClass arg2) {
        SearchException result = new SearchException(String.format(this.fieldBridgeNotTwoWay$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotTwoWay$str() {
        return fieldBridgeNotTwoWay;
    }

    @Override
    public final SearchException unableToParseDocument(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.unableToParseDocument$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToParseDocument$str() {
        return unableToParseDocument;
    }

    @Override
    public final SearchException noDocumentIdFoundException(String arg0) {
        SearchException result = new SearchException(String.format(this.noDocumentIdFoundException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDocumentIdFoundException$str() {
        return noDocumentIdFoundException;
    }

    @Override
    public final IllegalArgumentException getNullSessionPassedToFullTextSessionCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getNullSessionPassedToFullTextSessionCreationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullSessionPassedToFullTextSessionCreationException$str() {
        return getNullSessionPassedToFullTextSessionCreationException;
    }

    @Override
    public final IllegalArgumentException getNullSessionPassedToFullEntityManagerCreationException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getNullSessionPassedToFullEntityManagerCreationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullSessionPassedToFullEntityManagerCreationException$str() {
        return getNullSessionPassedToFullEntityManagerCreationException;
    }

    @Override
    public final ClassCastException getUnableToNarrowFieldDescriptorException(String arg0, String arg1, String arg2) {
        ClassCastException result = new ClassCastException(String.format(this.getUnableToNarrowFieldDescriptorException$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToNarrowFieldDescriptorException$str() {
        return getUnableToNarrowFieldDescriptorException;
    }

    @Override
    public final IllegalArgumentException getPropertyNameCannotBeNullException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getPropertyNameCannotBeNullException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyNameCannotBeNullException$str() {
        return getPropertyNameCannotBeNullException;
    }

    @Override
    public final IllegalArgumentException getFieldNameCannotBeNullException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getFieldNameCannotBeNullException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getFieldNameCannotBeNullException$str() {
        return getFieldNameCannotBeNullException;
    }

    @Override
    public final String massIndexerUnableToIndexInstance(String arg0, String arg1) {
        String result = String.format(this.massIndexerUnableToIndexInstance$str(), arg0, arg1);
        return result;
    }

    protected String massIndexerUnableToIndexInstance$str() {
        return massIndexerUnableToIndexInstance;
    }

    public final SearchException entityWithNoShard(Class arg0) {
        SearchException result = new SearchException(String.format(this.entityWithNoShard$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityWithNoShard$str() {
        return entityWithNoShard;
    }

    public final SearchException assertionFailureCannotCastToWorkerBuilderContext(Class arg0) {
        SearchException result = new SearchException(String.format(this.assertionFailureCannotCastToWorkerBuilderContext$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String assertionFailureCannotCastToWorkerBuilderContext$str() {
        return assertionFailureCannotCastToWorkerBuilderContext;
    }

    @Override
    public final SearchException getMultipleEntitiesShareIndexWithInconsistentSimilarityException(String arg0, String arg1, String arg2, String arg3) {
        SearchException result = new SearchException(String.format(this.getMultipleEntitiesShareIndexWithInconsistentSimilarityException$str(), arg0, arg1, arg2, arg3));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleEntitiesShareIndexWithInconsistentSimilarityException$str() {
        return getMultipleEntitiesShareIndexWithInconsistentSimilarityException;
    }

    @Override
    public final SearchException getNoSessionFactoryInContextException() {
        SearchException result = new SearchException(String.format(this.getNoSessionFactoryInContextException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoSessionFactoryInContextException$str() {
        return getNoSessionFactoryInContextException;
    }

    @Override
    public final SearchException getInvalidShardCountException(int arg0) {
        SearchException result = new SearchException(String.format(this.getInvalidShardCountException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidShardCountException$str() {
        return getInvalidShardCountException;
    }

    @Override
    public final SearchException getInvalidIntegerValueException(String arg0, Throwable arg1) {
        SearchException result = new SearchException(String.format(this.getInvalidIntegerValueException$str(), arg0), arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidIntegerValueException$str() {
        return getInvalidIntegerValueException;
    }

    @Override
    public final void idHashShardingWithSingleShard() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.idHashShardingWithSingleShard$str(), new Object[0]);
    }

    protected String idHashShardingWithSingleShard$str() {
        return idHashShardingWithSingleShard;
    }

    @Override
    public final SearchException getUnableToLoadShardingStrategyClassException(String arg0) {
        SearchException result = new SearchException(String.format(this.getUnableToLoadShardingStrategyClassException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToLoadShardingStrategyClassException$str() {
        return getUnableToLoadShardingStrategyClassException;
    }

    @Override
    public final SearchException getMultipleServiceImplementationsException(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.getMultipleServiceImplementationsException$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleServiceImplementationsException$str() {
        return getMultipleServiceImplementationsException;
    }

    @Override
    public final SearchException getNoServiceImplementationFoundException(String arg0) {
        SearchException result = new SearchException(String.format(this.getNoServiceImplementationFoundException$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoServiceImplementationFoundException$str() {
        return getNoServiceImplementationFoundException;
    }

    @Override
    public final SearchException getUnableToCreateJGroupsBackendException(Throwable arg0) {
        SearchException result = new SearchException(String.format(this.getUnableToCreateJGroupsBackendException$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToCreateJGroupsBackendException$str() {
        return getUnableToCreateJGroupsBackendException;
    }

    @Override
    public final SearchException getUnexpectedServiceStatusException(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.getUnexpectedServiceStatusException$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnexpectedServiceStatusException$str() {
        return getUnexpectedServiceStatusException;
    }

    @Override
    public final SearchException configurationPropertyCantBeEmpty(String arg0) {
        SearchException result = new SearchException(String.format(this.configurationPropertyCantBeEmpty$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configurationPropertyCantBeEmpty$str() {
        return configurationPropertyCantBeEmpty;
    }

    @Override
    public final SearchException incorrectEditDistance() {
        SearchException result = new SearchException(String.format(this.incorrectEditDistance$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incorrectEditDistance$str() {
        return incorrectEditDistance;
    }

    public final SearchException entityWithIdNotFound(Class arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.entityWithIdNotFound$str(), new ClassFormatter(arg0), arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String entityWithIdNotFound$str() {
        return entityWithIdNotFound;
    }

    public final SearchException noFieldCompatibleForMoreLikeThis(Class arg0) {
        SearchException result = new SearchException(String.format(this.noFieldCompatibleForMoreLikeThis$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldCompatibleForMoreLikeThis$str() {
        return noFieldCompatibleForMoreLikeThis;
    }

    public final SearchException ioExceptionOnIndexOfEntity(IOException arg0, Class arg1) {
        SearchException result = new SearchException(String.format(this.ioExceptionOnIndexOfEntity$str(), new ClassFormatter(arg1)), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndexOfEntity$str() {
        return ioExceptionOnIndexOfEntity;
    }

    public final SearchException requireTFIDFSimilarity(Class arg0) {
        SearchException result = new SearchException(String.format(this.requireTFIDFSimilarity$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requireTFIDFSimilarity$str() {
        return requireTFIDFSimilarity;
    }

    public final SearchException fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis(String arg0, Class arg1) {
        SearchException result = new SearchException(String.format(this.fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis$str(), arg0, new ClassFormatter(arg1)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis$str() {
        return fieldNotStoredNorTermVectorCannotBeUsedInMoreLikeThis;
    }

    @Override
    public final SearchException classLoaderServiceContainedInProvidedServicesException() {
        SearchException result = new SearchException(String.format(this.classLoaderServiceContainedInProvidedServicesException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String classLoaderServiceContainedInProvidedServicesException$str() {
        return classLoaderServiceContainedInProvidedServicesException;
    }

    @Override
    public final IllegalStateException serviceRequestedAfterReleasedAllWasCalled() {
        IllegalStateException result = new IllegalStateException(String.format(this.serviceRequestedAfterReleasedAllWasCalled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serviceRequestedAfterReleasedAllWasCalled$str() {
        return serviceRequestedAfterReleasedAllWasCalled;
    }

    @Override
    public final SearchException providedServicesCannotImplementStartableOrStoppable(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.providedServicesCannotImplementStartableOrStoppable$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String providedServicesCannotImplementStartableOrStoppable$str() {
        return providedServicesCannotImplementStartableOrStoppable;
    }

    @Override
    public final String massIndexerExceptionWhileFetchingIds() {
        String result = String.format(this.massIndexerExceptionWhileFetchingIds$str(), new Object[0]);
        return result;
    }

    protected String massIndexerExceptionWhileFetchingIds$str() {
        return massIndexerExceptionWhileFetchingIds;
    }

    @Override
    public final String massIndexerExceptionWhileTransformingIds() {
        String result = String.format(this.massIndexerExceptionWhileTransformingIds$str(), new Object[0]);
        return result;
    }

    protected String massIndexerExceptionWhileTransformingIds$str() {
        return massIndexerExceptionWhileTransformingIds;
    }

    public final SearchException fieldIdCannotBeUsedInMoreLikeThis(String arg0, Class arg1) {
        SearchException result = new SearchException(String.format(this.fieldIdCannotBeUsedInMoreLikeThis$str(), arg0, new ClassFormatter(arg1)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldIdCannotBeUsedInMoreLikeThis$str() {
        return fieldIdCannotBeUsedInMoreLikeThis;
    }

    public final SearchException numericFieldCannotBeUsedInMoreLikeThis(String arg0, Class arg1) {
        SearchException result = new SearchException(String.format(this.numericFieldCannotBeUsedInMoreLikeThis$str(), arg0, new ClassFormatter(arg1)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericFieldCannotBeUsedInMoreLikeThis$str() {
        return numericFieldCannotBeUsedInMoreLikeThis;
    }

    @Override
    public final SearchException multipleMatchingFieldBridges(XMember arg0, XClass arg1, String arg2) {
        SearchException result = new SearchException(String.format(this.multipleMatchingFieldBridges$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleMatchingFieldBridges$str() {
        return multipleMatchingFieldBridges;
    }

    @Override
    public final SearchException invalidIncludePathConfiguration(String arg0, String arg1, String arg2) {
        SearchException result = new SearchException(String.format(this.invalidIncludePathConfiguration$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIncludePathConfiguration$str() {
        return invalidIncludePathConfiguration;
    }

    @Override
    public final SearchException invalidPropertyValue(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.invalidPropertyValue$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPropertyValue$str() {
        return invalidPropertyValue;
    }

    @Override
    public final SearchException unknownFieldNameForMoreLikeThisQuery(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.unknownFieldNameForMoreLikeThisQuery$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldNameForMoreLikeThisQuery$str() {
        return unknownFieldNameForMoreLikeThisQuery;
    }

    @Override
    public final SearchException jmsInitialContextException(String arg0, String arg1, Exception arg2) {
        SearchException result = new SearchException(String.format(this.jmsInitialContextException$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsInitialContextException$str() {
        return jmsInitialContextException;
    }

    @Override
    public final SearchException jmsQueueFactoryLookupException(String arg0, String arg1, Exception arg2) {
        SearchException result = new SearchException(String.format(this.jmsQueueFactoryLookupException$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsQueueFactoryLookupException$str() {
        return jmsQueueFactoryLookupException;
    }

    @Override
    public final SearchException detectInfiniteTypeLoopInIndexedEmbedded(String arg0, String arg1, String arg2) {
        SearchException result = new SearchException(String.format(this.detectInfiniteTypeLoopInIndexedEmbedded$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String detectInfiniteTypeLoopInIndexedEmbedded$str() {
        return detectInfiniteTypeLoopInIndexedEmbedded;
    }

    @Override
    public final SearchException searchIntegratorNotInitialized() {
        SearchException result = new SearchException(String.format(this.searchIntegratorNotInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String searchIntegratorNotInitialized$str() {
        return searchIntegratorNotInitialized;
    }

    @Override
    public final SearchException searchFactoryReferenceServiceNotFound() {
        SearchException result = new SearchException(String.format(this.searchFactoryReferenceServiceNotFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String searchFactoryReferenceServiceNotFound$str() {
        return searchFactoryReferenceServiceNotFound;
    }

    @Override
    public final AssertionFailure parametersShouldNotBeNull(String arg0) {
        AssertionFailure result = new AssertionFailure(String.format(this.parametersShouldNotBeNull$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parametersShouldNotBeNull$str() {
        return parametersShouldNotBeNull;
    }

    @Override
    public final void lockingFailureDuringInitialization(String arg0) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.lockingFailureDuringInitialization$str(), (Object)arg0);
    }

    protected String lockingFailureDuringInitialization$str() {
        return lockingFailureDuringInitialization;
    }

    @Override
    public final void logInfoStreamMessage(String arg0, String arg1) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.logInfoStreamMessage$str(), (Object)arg0, (Object)arg1);
    }

    protected String logInfoStreamMessage$str() {
        return logInfoStreamMessage;
    }

    @Override
    public final SearchException booleanQueryWithoutClauses() {
        SearchException result = new SearchException(String.format(this.booleanQueryWithoutClauses$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String booleanQueryWithoutClauses$str() {
        return booleanQueryWithoutClauses;
    }

    @Override
    public final SearchException illegalLuceneVersionFormat(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.illegalLuceneVersionFormat$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalLuceneVersionFormat$str() {
        return illegalLuceneVersionFormat;
    }

    @Override
    public final SearchException flushIntervalNeedsToBePositive(String arg0) {
        SearchException result = new SearchException(String.format(this.flushIntervalNeedsToBePositive$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String flushIntervalNeedsToBePositive$str() {
        return flushIntervalNeedsToBePositive;
    }

    @Override
    public final void startingSyncConsumerThread(String arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.startingSyncConsumerThread$str(), (Object)arg0);
    }

    protected String startingSyncConsumerThread$str() {
        return startingSyncConsumerThread;
    }

    @Override
    public final void stoppingSyncConsumerThread(String arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.stoppingSyncConsumerThread$str(), (Object)arg0);
    }

    protected String stoppingSyncConsumerThread$str() {
        return stoppingSyncConsumerThread;
    }

    @Override
    public final SearchException stringEncodedFieldsAreTargetedWithNumericQuery(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.stringEncodedFieldsAreTargetedWithNumericQuery$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String stringEncodedFieldsAreTargetedWithNumericQuery$str() {
        return stringEncodedFieldsAreTargetedWithNumericQuery;
    }

    @Override
    public final SearchException numericEncodedFieldsAreTargetedWithStringQuery(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.numericEncodedFieldsAreTargetedWithStringQuery$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericEncodedFieldsAreTargetedWithStringQuery$str() {
        return numericEncodedFieldsAreTargetedWithStringQuery;
    }

    @Override
    public final IllegalArgumentException targetedEntityTypesNotIndexed(String arg0) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.targetedEntityTypesNotIndexed$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetedEntityTypesNotIndexed$str() {
        return targetedEntityTypesNotIndexed;
    }

    @Override
    public final void luceneBackendInitializedSynchronously(String arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.luceneBackendInitializedSynchronously$str(), (Object)arg0);
    }

    protected String luceneBackendInitializedSynchronously$str() {
        return luceneBackendInitializedSynchronously;
    }

    @Override
    public final void luceneBackendInitializedAsynchronously(String arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.luceneBackendInitializedAsynchronously$str(), (Object)arg0);
    }

    protected String luceneBackendInitializedAsynchronously$str() {
        return luceneBackendInitializedAsynchronously;
    }

    @Override
    public final SearchException rangeQueryWithNullToAndFromValue(String arg0) {
        SearchException result = new SearchException(String.format(this.rangeQueryWithNullToAndFromValue$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rangeQueryWithNullToAndFromValue$str() {
        return rangeQueryWithNullToAndFromValue;
    }

    @Override
    public final SearchException numericRangeQueryWithNonNumericToAndFromValues(String arg0) {
        SearchException result = new SearchException(String.format(this.numericRangeQueryWithNonNumericToAndFromValues$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericRangeQueryWithNonNumericToAndFromValues$str() {
        return numericRangeQueryWithNonNumericToAndFromValues;
    }

    @Override
    public final AssertionFailure unknownEncodingType(String arg0) {
        AssertionFailure result = new AssertionFailure(String.format(this.unknownEncodingType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownEncodingType$str() {
        return unknownEncodingType;
    }

    @Override
    public final SearchException invalidStringDateFieldInDocument(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.invalidStringDateFieldInDocument$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidStringDateFieldInDocument$str() {
        return invalidStringDateFieldInDocument;
    }

    @Override
    public final SearchException multipleFactoryMethodsInClass(String arg0) {
        SearchException result = new SearchException(String.format(this.multipleFactoryMethodsInClass$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleFactoryMethodsInClass$str() {
        return multipleFactoryMethodsInClass;
    }

    @Override
    public final SearchException noPublicNoArgConstructor(String arg0) {
        SearchException result = new SearchException(String.format(this.noPublicNoArgConstructor$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPublicNoArgConstructor$str() {
        return noPublicNoArgConstructor;
    }

    @Override
    public final SearchException unableToAccessClass(String arg0) {
        SearchException result = new SearchException(String.format(this.unableToAccessClass$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToAccessClass$str() {
        return unableToAccessClass;
    }

    @Override
    public final SearchException factoryMethodsMustReturnAnObject(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.factoryMethodsMustReturnAnObject$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String factoryMethodsMustReturnAnObject$str() {
        return factoryMethodsMustReturnAnObject;
    }

    @Override
    public final SearchException unableToAccessMethod(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.unableToAccessMethod$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToAccessMethod$str() {
        return unableToAccessMethod;
    }

    @Override
    public final SearchException exceptionDuringFactoryMethodExecution(Exception arg0, String arg1, String arg2) {
        SearchException result = new SearchException(String.format(this.exceptionDuringFactoryMethodExecution$str(), arg1, arg2), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String exceptionDuringFactoryMethodExecution$str() {
        return exceptionDuringFactoryMethodExecution;
    }

    @Override
    public final SearchException fieldTriesToOverrideIdFieldSettings(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.fieldTriesToOverrideIdFieldSettings$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldTriesToOverrideIdFieldSettings$str() {
        return fieldTriesToOverrideIdFieldSettings;
    }

    @Override
    public final void workListShouldNeverBeEmpty(String arg0) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)null, this.workListShouldNeverBeEmpty$str(), (Object)arg0);
    }

    protected String workListShouldNeverBeEmpty$str() {
        return workListShouldNeverBeEmpty;
    }

    @Override
    public final void singleTermDeleteDisabled(String arg0) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.singleTermDeleteDisabled$str(), (Object)arg0);
    }

    protected String singleTermDeleteDisabled$str() {
        return singleTermDeleteDisabled;
    }

    public final SearchException unsupportedErrorHandlerConfigurationValueType(Class arg0) {
        SearchException result = new SearchException(String.format(this.unsupportedErrorHandlerConfigurationValueType$str(), new ClassFormatter(arg0)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedErrorHandlerConfigurationValueType$str() {
        return unsupportedErrorHandlerConfigurationValueType;
    }

    public final SearchException unableToSetFilterParameter(Class arg0, String arg1, Exception arg2) {
        SearchException result = new SearchException(String.format(this.unableToSetFilterParameter$str(), new ClassFormatter(arg0), arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetFilterParameter$str() {
        return unableToSetFilterParameter;
    }

    public final SearchException cannotInitializeDirectoryProvider(Class arg0, String arg1, Exception arg2) {
        SearchException result = new SearchException(String.format(this.cannotInitializeDirectoryProvider$str(), new ClassFormatter(arg0), arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInitializeDirectoryProvider$str() {
        return cannotInitializeDirectoryProvider;
    }

    @Override
    public final SearchException indexBasePathRequiredForLockingStrategy(String arg0) {
        SearchException result = new SearchException(String.format(this.indexBasePathRequiredForLockingStrategy$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexBasePathRequiredForLockingStrategy$str() {
        return indexBasePathRequiredForLockingStrategy;
    }

    @Override
    public final SearchException unknownIndexingMode(String arg0) {
        SearchException result = new SearchException(String.format(this.unknownIndexingMode$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownIndexingMode$str() {
        return unknownIndexingMode;
    }

    @Override
    public final SearchException unknownDocValuesTypeType(String arg0) {
        SearchException result = new SearchException(String.format(this.unknownDocValuesTypeType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownDocValuesTypeType$str() {
        return unknownDocValuesTypeType;
    }

    @Override
    public final SearchException unexpectedBinaryDocValuesTypeType(String arg0) {
        SearchException result = new SearchException(String.format(this.unexpectedBinaryDocValuesTypeType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedBinaryDocValuesTypeType$str() {
        return unexpectedBinaryDocValuesTypeType;
    }

    @Override
    public final SearchException unexpectedNumericDocValuesTypeType(String arg0) {
        SearchException result = new SearchException(String.format(this.unexpectedNumericDocValuesTypeType$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedNumericDocValuesTypeType$str() {
        return unexpectedNumericDocValuesTypeType;
    }

    @Override
    public final void loadingNonExistentField(String arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)null, this.loadingNonExistentField$str(), (Object)arg0);
    }

    protected String loadingNonExistentField$str() {
        return loadingNonExistentField;
    }

    public final SearchException unableToDeleteByQuery(Class arg0, DeletionQuery arg1, Exception arg2) {
        SearchException result = new SearchException(String.format(this.unableToDeleteByQuery$str(), arg0, arg1), arg2);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeleteByQuery$str() {
        return unableToDeleteByQuery;
    }

    @Override
    public final void givenCriteriaObjectCannotBeApplied() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.givenCriteriaObjectCannotBeApplied$str(), new Object[0]);
    }

    protected String givenCriteriaObjectCannotBeApplied$str() {
        return givenCriteriaObjectCannotBeApplied;
    }

    @Override
    public final SearchException unknownDeletionQueryKeySpecified(int arg0) {
        SearchException result = new SearchException(String.format(this.unknownDeletionQueryKeySpecified$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownDeletionQueryKeySpecified$str() {
        return unknownDeletionQueryKeySpecified;
    }

    @Override
    public final SearchException numericFieldAnnotationWithoutMatchingField(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.numericFieldAnnotationWithoutMatchingField$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericFieldAnnotationWithoutMatchingField$str() {
        return numericFieldAnnotationWithoutMatchingField;
    }

    @Override
    public final SearchException facetAnnotationWithoutMatchingField(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.facetAnnotationWithoutMatchingField$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String facetAnnotationWithoutMatchingField$str() {
        return facetAnnotationWithoutMatchingField;
    }

    @Override
    public final SearchException unsupportedFieldTypeForFaceting(String arg0, String arg1, String arg2) {
        SearchException result = new SearchException(String.format(this.unsupportedFieldTypeForFaceting$str(), arg0, arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFieldTypeForFaceting$str() {
        return unsupportedFieldTypeForFaceting;
    }

    @Override
    public final SearchException errorDuringFacetingIndexing(Exception arg0) {
        SearchException result = new SearchException(String.format(this.errorDuringFacetingIndexing$str(), new Object[0]), arg0);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorDuringFacetingIndexing$str() {
        return errorDuringFacetingIndexing;
    }

    @Override
    public final SearchException unsupportedFacetRangeParameter(String arg0) {
        SearchException result = new SearchException(String.format(this.unsupportedFacetRangeParameter$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFacetRangeParameter$str() {
        return unsupportedFacetRangeParameter;
    }

    @Override
    public final SearchException numericDateFacetForNonNumericField(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.numericDateFacetForNonNumericField$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String numericDateFacetForNonNumericField$str() {
        return numericDateFacetForNonNumericField;
    }

    @Override
    public final SearchException unknownFieldNameForFaceting(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.unknownFieldNameForFaceting$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldNameForFaceting$str() {
        return unknownFieldNameForFaceting;
    }

    @Override
    public final SearchException unsupportedParameterTypeForRangeFaceting(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.unsupportedParameterTypeForRangeFaceting$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedParameterTypeForRangeFaceting$str() {
        return unsupportedParameterTypeForRangeFaceting;
    }

    @Override
    public final SearchException noStartOrEndSpecifiedForRangeQuery(String arg0) {
        SearchException result = new SearchException(String.format(this.noStartOrEndSpecifiedForRangeQuery$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noStartOrEndSpecifiedForRangeQuery$str() {
        return noStartOrEndSpecifiedForRangeQuery;
    }

    @Override
    public final SearchException rangeDefinitionOrderRequestedForDiscrteFacetRequest() {
        SearchException result = new SearchException(String.format(this.rangeDefinitionOrderRequestedForDiscrteFacetRequest$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rangeDefinitionOrderRequestedForDiscrteFacetRequest$str() {
        return rangeDefinitionOrderRequestedForDiscrteFacetRequest;
    }

    @Override
    public final SearchException attemptToCreateFacetingRequestForUnindexedEntity(String arg0) {
        SearchException result = new SearchException(String.format(this.attemptToCreateFacetingRequestForUnindexedEntity$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attemptToCreateFacetingRequestForUnindexedEntity$str() {
        return attemptToCreateFacetingRequestForUnindexedEntity;
    }

    @Override
    public final SearchException attemptToFacetOnAnalyzedField(String arg0, String arg1) {
        SearchException result = new SearchException(String.format(this.attemptToFacetOnAnalyzedField$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attemptToFacetOnAnalyzedField$str() {
        return attemptToFacetOnAnalyzedField;
    }
}

