/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector.impl;

import java.io.IOException;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class FacetsCollectorDecorator
extends Collector {
    private final Collector nextInChainCollector;
    private final FacetsCollector facetsCollector;

    public FacetsCollectorDecorator(FacetsCollector facetsCollector, Collector nextInChainCollector) {
        this.nextInChainCollector = nextInChainCollector;
        this.facetsCollector = facetsCollector;
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.facetsCollector.setNextReader(context);
        this.nextInChainCollector.setNextReader(context);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.facetsCollector.collect(doc);
        this.nextInChainCollector.collect(doc);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.facetsCollector.setScorer(scorer);
        this.nextInChainCollector.setScorer(scorer);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.nextInChainCollector.acceptsDocsOutOfOrder();
    }
}

