/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public final class DistanceComparator
extends FieldComparator<Double> {
    private final Point center;
    private final String latitudeField;
    private final String longitudeField;
    private double[] distances;
    private FieldCache.Doubles latitudeValues;
    private FieldCache.Doubles longitudeValues;
    private Double bottomDistance;
    private Double topValue;

    public DistanceComparator(Point center, int numHits, String fieldName) {
        this.center = center;
        this.distances = new double[numHits];
        this.latitudeField = SpatialHelper.formatLatitude(fieldName);
        this.longitudeField = SpatialHelper.formatLongitude(fieldName);
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Double.compare(this.distances[slot1], this.distances[slot2]);
    }

    @Override
    public void setBottom(int slot) {
        this.bottomDistance = this.distances[slot];
    }

    @Override
    public void setTopValue(Double value) {
        this.topValue = value;
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        return Double.compare(this.bottomDistance, this.center.getDistanceTo(this.latitudeValues.get(doc), this.longitudeValues.get(doc)));
    }

    @Override
    public int compareTop(int doc) throws IOException {
        if (this.topValue == null) {
            return 1;
        }
        double distanceTo = this.center.getDistanceTo(this.latitudeValues.get(doc), this.longitudeValues.get(doc));
        return Double.compare(distanceTo, this.topValue);
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.distances[slot] = this.center.getDistanceTo(this.latitudeValues.get(doc), this.longitudeValues.get(doc));
    }

    public DistanceComparator setNextReader(AtomicReaderContext context) throws IOException {
        this.latitudeValues = FieldCache.DEFAULT.getDoubles(context.reader(), this.latitudeField, false);
        this.longitudeValues = FieldCache.DEFAULT.getDoubles(context.reader(), this.longitudeField, false);
        return this;
    }

    @Override
    public Double value(int slot) {
        return this.distances[slot];
    }
}

