/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.analyzerdefs;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.fest.assertions.Assertions;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AnalyzerDefsAnnotationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Sample.class);

    @Test
    public void shouldBePossibleToAnnotatePackage() throws Exception {
        this.assertThatAnalyzerExists("package-analyzer-1");
        this.assertThatAnalyzerExists("package-analyzer-2");
    }

    @Test
    public void shouldBePossibleToAnnotateClass() throws Exception {
        this.assertThatAnalyzerExists("class-analyzer-1");
        this.assertThatAnalyzerExists("class-analyzer-2");
    }

    @Test
    public void shouldContainOnlyTheDefinedAnalyzers() throws Exception {
        Map<String, Analyzer> analyzers = ((SearchFactoryState)((Object)this.sfHolder.getSearchFactory())).getAnalyzers();
        Assertions.assertThat(analyzers.keySet()).containsOnly(new Object[]{"package-analyzer-1", "package-analyzer-2", "class-analyzer-1", "class-analyzer-2"});
    }

    @Test
    public void shouldNotBePossibleToHaveTwoAnalyzerDefsWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithError.class);
        new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator().close();
    }

    private void assertThatAnalyzerExists(String analyzerName) {
        Analyzer analyzer = this.sfHolder.getSearchFactory().getAnalyzer(analyzerName);
        Assertions.assertThat((Object)analyzer).isNotNull();
    }

    @Indexed
    @AnalyzerDefs(value={@AnalyzerDef(name="package-analyzer-1", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class)), @AnalyzerDef(name="class-analyzer-unique", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))})
    static class SampleWithError {
        @DocumentId
        final long id = 1L;
        @Field
        final String description = "";

        SampleWithError() {
        }
    }

    @Indexed
    @AnalyzerDefs(value={@AnalyzerDef(name="class-analyzer-1", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class)), @AnalyzerDef(name="class-analyzer-2", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))})
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;

        Sample() {
        }
    }
}

