/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.impl.DeleteByQuerySupport;
import org.hibernate.search.backend.spi.DeleteByQueryWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.SingularTermDeletionQuery;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DeleteByQueryTest {
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Book.class);

    @Test
    public void testStringSerialization() {
        for (DeletionQuery q : this.buildQueries()) {
            this.testSerializationForQuery(q);
        }
    }

    private List<DeletionQuery> buildQueries() {
        ArrayList<DeletionQuery> l = new ArrayList<DeletionQuery>();
        l.add(new SingularTermDeletionQuery("id", "123"));
        l.addAll(this.buildNumQueries());
        return l;
    }

    private List<SingularTermDeletionQuery> buildNumQueries() {
        ArrayList<SingularTermDeletionQuery> l = new ArrayList<SingularTermDeletionQuery>();
        l.add(new SingularTermDeletionQuery("intField", 1));
        l.add(new SingularTermDeletionQuery("longField", 1L));
        l.add(new SingularTermDeletionQuery("floatField", 1.0f));
        l.add(new SingularTermDeletionQuery("doubleField", 1.0));
        return l;
    }

    private List<Integer> expectedCount() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(1);
        l.add(1);
        l.add(1);
        return l;
    }

    @Test
    public void testSingularTermQuery() {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        Worker worker = integrator.getWorker();
        TransactionContextForTest tc = new TransactionContextForTest();
        for (Work work : this.makeBooksForSingularTermQuery()) {
            worker.performWork(work, tc);
        }
        tc.end();
        this.assertCount(2, integrator);
        tc = new TransactionContextForTest();
        worker.performWork(new DeleteByQueryWork(Book.class, new SingularTermDeletionQuery("id", String.valueOf(5))), tc);
        tc.end();
        this.assertCount(1, integrator);
        tc = new TransactionContextForTest();
        worker.performWork(new DeleteByQueryWork(Book.class, new SingularTermDeletionQuery("id", String.valueOf(6))), tc);
        tc.end();
        this.assertCount(0, integrator);
    }

    @Test
    public void testNumRangeQuery() {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        List<SingularTermDeletionQuery> numQueries = this.buildNumQueries();
        List<Integer> expectedCount = this.expectedCount();
        Assert.assertEquals((long)expectedCount.size(), (long)numQueries.size());
        for (int i = 0; i < numQueries.size(); ++i) {
            try {
                this.testForQuery(integrator, numQueries.get(i), expectedCount.get(i));
                continue;
            }
            catch (Throwable e) {
                System.out.println("ERROR: " + numQueries.get(i) + ". expected was: " + expectedCount.get(i));
                throw e;
            }
        }
    }

    private void testForQuery(ExtendedSearchIntegrator integrator, DeletionQuery query, int expectedCount) {
        Worker worker = integrator.getWorker();
        TransactionContextForTest tc = new TransactionContextForTest();
        for (Work work : this.makeBooksForNumRangeQuery()) {
            worker.performWork(work, tc);
        }
        tc.end();
        this.assertCount(2, integrator);
        tc = new TransactionContextForTest();
        worker.performWork(new DeleteByQueryWork(Book.class, query), tc);
        tc.end();
        this.assertCount(expectedCount, integrator);
        tc = new TransactionContextForTest();
        worker.performWork(new Work(Book.class, null, WorkType.PURGE_ALL), tc);
        tc.end();
        this.assertCount(0, integrator);
    }

    private void assertCount(int count, ExtendedSearchIntegrator integrator) {
        Query query = integrator.buildQueryBuilder().forEntity(Book.class).get().all().createQuery();
        HSQuery hsQuery = integrator.createHSQuery().luceneQuery(query);
        ArrayList l = new ArrayList();
        l.add(Book.class);
        hsQuery.targetedEntities(l);
        Assert.assertEquals((long)count, (long)hsQuery.queryResultSize());
    }

    private void testSerializationForQuery(DeletionQuery deletionQuery) {
        Assert.assertTrue((boolean)DeleteByQuerySupport.isSupported(deletionQuery.getClass()));
        String[] strRep = deletionQuery.serialize();
        DeletionQuery copy = DeleteByQuerySupport.fromString(deletionQuery.getQueryKey(), strRep);
        Assert.assertEquals((Object)deletionQuery, (Object)copy);
    }

    private List<Work> makeBooksForSingularTermQuery() {
        LinkedList<Work> list = new LinkedList<Work>();
        list.add(new Work(new Book(String.valueOf(5), "Lord of The Rings"), WorkType.ADD));
        list.add(new Work(new Book(String.valueOf(6), "The Hobbit"), WorkType.ADD));
        return list;
    }

    private List<Work> makeBooksForNumRangeQuery() {
        LinkedList<Work> list = new LinkedList<Work>();
        list.add(new Work(new Book(String.valueOf(5), 1, 1L, Float.valueOf(1.0f), 1.0, "Lord of The Rings"), WorkType.ADD));
        list.add(new Work(new Book(String.valueOf(6), 2, 2L, Float.valueOf(2.0f), 2.0, "The Hobbit"), WorkType.ADD));
        return list;
    }

    @Indexed(index="books")
    private static class Book {
        @DocumentId
        String id;
        @Field(store=Store.YES, index=Index.YES)
        Integer intField;
        @Field(store=Store.YES, index=Index.YES)
        Long longField;
        @Field(store=Store.YES, index=Index.YES)
        Float floatField;
        @Field(store=Store.YES, index=Index.YES)
        Double doubleField;
        @Field
        String title;

        public Book(String id, String title) {
            this.id = id;
            this.title = title;
        }

        public Book(String id, Integer intField, Long longField, Float floatField, Double doubleField, String title) {
            this.id = id;
            this.intField = intField;
            this.longField = longField;
            this.floatField = floatField;
            this.doubleField = doubleField;
            this.title = title;
        }
    }
}

