/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.test.configuration.BaseConfigurationTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;

public class DeleteByTermEnforcementTest
extends BaseConfigurationTest {
    @Test
    public void testDefaultValue() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setDeleteByTermEnforced(true);
        this.verifyDeleteByTermEnforced(cfg);
    }

    private void verifyDeleteByTermEnforced(SearchConfigurationForTest cfg) {
        try (MutableSearchFactory sf = this.getMutableSearchFactoryWithSingleEntity(cfg);){
            Assert.assertTrue((boolean)DeleteByTermEnforcementTest.extractWorkspace(sf, BaseConfigurationTest.Document.class).isDeleteByTermEnforced());
            sf.addClasses(BaseConfigurationTest.Dvd.class, BaseConfigurationTest.Book.class);
            Assert.assertTrue((boolean)DeleteByTermEnforcementTest.extractWorkspace(sf, BaseConfigurationTest.Book.class).isDeleteByTermEnforced());
            Assert.assertTrue((boolean)DeleteByTermEnforcementTest.extractWorkspace(sf, BaseConfigurationTest.Dvd.class).isDeleteByTermEnforced());
            Assert.assertTrue((boolean)DeleteByTermEnforcementTest.extractWorkspace(sf, BaseConfigurationTest.Document.class).isDeleteByTermEnforced());
        }
    }
}

