/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1758")
public class NumericTypeGuessedTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(CustomBridgedNumbers.class);

    @Test
    public void verifyExceptionOnNonMeaningfullQueries() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        this.storeData("title-one", "1");
        this.storeData("title-two", "2");
        this.storeData("title-three", "3");
        QueryBuilder queryBuilder = searchFactory.buildQueryBuilder().forEntity(CustomBridgedNumbers.class).get();
        Query query = queryBuilder.range().onField("customField").from(1).excludeLimit().to(3).excludeLimit().createQuery();
        List<EntityInfo> queryEntityInfos = searchFactory.createHSQuery().luceneQuery(query).targetedEntities(Arrays.asList(CustomBridgedNumbers.class)).projection("title").queryEntityInfos();
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        EntityInfo entityInfo = queryEntityInfos.get(0);
        Assert.assertEquals((Object)"title-two", (Object)entityInfo.getProjection()[0]);
    }

    private void storeData(String title, String value) {
        CustomBridgedNumbers entry = new CustomBridgedNumbers();
        entry.title = title;
        entry.textEncodedInt = value;
        Work work = new Work(entry, (Serializable)((Object)entry.title), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        this.sfHolder.getSearchFactory().getWorker().performWork(work, tc);
        tc.end();
    }

    public static class NumericEncodingCustom
    implements org.hibernate.search.bridge.FieldBridge {
        @Override
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (value != null) {
                Integer i = Integer.parseInt((String)value);
                luceneOptions.addNumericFieldToDocument("customField", i, document);
            }
        }
    }

    @Indexed
    public static class CustomBridgedNumbers {
        @DocumentId
        String title;
        @Field(bridge=@FieldBridge(impl=NumericEncodingCustom.class))
        String textEncodedInt;
    }
}

