/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1026")
public class MultipleStatisticsMBeanTest {
    private static File simpleJndiDir;
    private static MBeanServer mbeanServer;

    @BeforeClass
    public static void beforeClass() {
        File targetDir = TestConstants.getTargetDir(MultipleStatisticsMBeanTest.class);
        simpleJndiDir = new File(targetDir, "simpleJndi");
        simpleJndiDir.mkdir();
        mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @AfterClass
    public static void afterClass() {
        simpleJndiDir.delete();
    }

    @Test
    public void testDefaultRegistration() throws Exception {
        String suffix = null;
        try (SearchIntegrator searchFactory = this.createSearchIntegratorUsingJndiPrefix(suffix);){
            this.testStatisticsMBeanRegistered(suffix);
        }
    }

    @Test
    public void testRegistrationWithSuffix() throws Exception {
        String suffix = "myapp";
        try (SearchIntegrator searchFactory = this.createSearchIntegratorUsingJndiPrefix(suffix);){
            this.testStatisticsMBeanRegistered(suffix);
        }
    }

    @Test
    public void testMultipleMbeanRegistration() throws Exception {
        String suffixApp1 = "app-1";
        try (SearchIntegrator factory1 = this.createSearchIntegratorUsingJndiPrefix(suffixApp1);){
            this.testStatisticsMBeanRegistered(suffixApp1);
            String suffixApp2 = "app-2";
            try (SearchIntegrator factory2 = this.createSearchIntegratorUsingJndiPrefix(suffixApp2);){
                this.testStatisticsMBeanRegistered(suffixApp2);
            }
        }
    }

    @Test
    public void testStatisticMBeanGetsUnregistered() throws Exception {
        String suffix = "myapp";
        try (SearchIntegrator searchFactory = this.createSearchIntegratorUsingJndiPrefix(suffix);){
            this.testStatisticsMBeanRegistered(suffix);
        }
        this.testStatisticsMBeanUnregistered(suffix);
    }

    private void testStatisticsMBeanUnregistered(String suffix) throws Exception {
        String objectName = JMXRegistrar.buildMBeanName("org.hibernate.search.jmx:type=StatisticsInfoMBean", suffix);
        ObjectName statisticsBeanObjectName = new ObjectName(objectName);
        Assert.assertFalse((String)"The MBean should be unregistered", (boolean)mbeanServer.isRegistered(statisticsBeanObjectName));
    }

    private void testStatisticsMBeanRegistered(String suffix) throws Exception {
        String objectName = JMXRegistrar.buildMBeanName("org.hibernate.search.jmx:type=StatisticsInfoMBean", suffix);
        ObjectName statisticsBeanObjectName = new ObjectName(objectName);
        ObjectInstance mBean = null;
        try {
            mBean = mbeanServer.getObjectInstance(statisticsBeanObjectName);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)("The mbean " + statisticsBeanObjectName.getCanonicalName() + " should be registered with the MBean server "));
        }
        Assert.assertEquals((Object)JMXRegistrar.StatisticsInfo.class.getName(), (Object)mBean.getClassName());
    }

    private SearchIntegrator createSearchIntegratorUsingJndiPrefix(String suffix) {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest().addProperty("hibernate.session_factory_name", "java:comp/SessionFactory").addProperty("hibernate.jndi.class", "org.osjava.sj.SimpleContextFactory").addProperty("hibernate.jndi.org.osjava.sj.root", simpleJndiDir.getAbsolutePath()).addProperty("hibernate.jndi.org.osjava.sj.jndi.shared", "true").addProperty("hibernate.search.jmx_enabled", "true");
        if (suffix != null) {
            configuration.addProperty("hibernate.search.jmx_bean_suffix", suffix);
        }
        return new SearchIntegratorBuilder().configuration(configuration).buildSearchIntegrator();
    }
}

