/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.engine;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.query.engine.impl.FieldNameCollector;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldNameCollectorTest {
    DirectoryReader indexReader;

    @Before
    public void setUp() throws Exception {
        RAMDirectory directory = new RAMDirectory();
        this.indexTestDocuments(directory);
        this.indexReader = DirectoryReader.open(directory);
    }

    @After
    public void tearDown() throws Exception {
        this.indexReader.close();
    }

    @Test
    public void testExtractFieldNameFromTermQuery() {
        TermQuery query = new TermQuery(new Term("stringField", "foobar"));
        this.assertFieldNames(query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromWildcardQuery() {
        WildcardQuery query = new WildcardQuery(new Term("stringField", "foo*"));
        this.assertFieldNames(query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromFuzzyQuery() {
        FuzzyQuery query = new FuzzyQuery(new Term("stringField", "foo*"));
        this.assertFieldNames(query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromRegexpQuery() {
        RegexpQuery query = new RegexpQuery(new Term("stringField", ".foo?"));
        this.assertFieldNames(query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromPrefixQuery() {
        PrefixQuery query = new PrefixQuery(new Term("stringField", "foo*"));
        this.assertFieldNames(query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromMultiPhraseQuery() {
        MultiPhraseQuery phraseQuery = new MultiPhraseQuery();
        phraseQuery.add(new Term("stringField1", "hello world"));
        this.assertFieldNames(phraseQuery, FieldType.STRING, "stringField1");
    }

    @Test
    public void testExtractFieldNameFromPhraseQuery() {
        PhraseQuery phraseQuery = new PhraseQuery();
        phraseQuery.add(new Term("stringField", "hello world"));
        this.assertFieldNames(phraseQuery, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromTermRangeQuery() {
        TermRangeQuery query = TermRangeQuery.newStringRange("stringField", "A", "Z", true, true);
        this.assertFieldNames(query, FieldType.STRING, "stringField");
    }

    @Test
    public void testExtractFieldNameFromNumericRangeQuery() {
        NumericRangeQuery<Integer> query = NumericRangeQuery.newIntRange("intField", 0, 0, true, true);
        this.assertFieldNames(query, FieldType.NUMBER, "intField");
    }

    @Test
    public void testBooleanQuery() {
        BooleanQuery booleanQuery = new BooleanQuery();
        TermQuery termQuery = new TermQuery(new Term("stringField", "foobar"));
        booleanQuery.add(termQuery, BooleanClause.Occur.MUST);
        NumericRangeQuery<Integer> numericRangeQuery = NumericRangeQuery.newIntRange("intField", 0, 0, true, true);
        booleanQuery.add(numericRangeQuery, BooleanClause.Occur.SHOULD);
        this.assertFieldNames(booleanQuery, FieldType.NUMBER, "intField");
        this.assertFieldNames(booleanQuery, FieldType.STRING, "stringField");
    }

    @Test
    public void testNestedBooleanQuery() {
        BooleanQuery booleanQuery = new BooleanQuery();
        TermQuery termQuery = new TermQuery(new Term("stringField", "foobar"));
        booleanQuery.add(termQuery, BooleanClause.Occur.MUST);
        BooleanQuery nestedBooleanQuery = new BooleanQuery();
        NumericRangeQuery<Integer> numericRangeQuery = NumericRangeQuery.newIntRange("intField", 0, 0, true, true);
        nestedBooleanQuery.add(numericRangeQuery, BooleanClause.Occur.SHOULD);
        booleanQuery.add(nestedBooleanQuery, BooleanClause.Occur.MUST);
        this.assertFieldNames(booleanQuery, FieldType.NUMBER, "intField");
        this.assertFieldNames(booleanQuery, FieldType.STRING, "stringField");
    }

    @Test
    public void testDisjunctionMaxQuery() {
        DisjunctionMaxQuery disjunctionMaxQuery = new DisjunctionMaxQuery(0.0f);
        TermQuery termQuery = new TermQuery(new Term("stringField", "foobar"));
        disjunctionMaxQuery.add(termQuery);
        NumericRangeQuery<Integer> numericRangeQuery = NumericRangeQuery.newIntRange("intField", 0, 0, true, true);
        disjunctionMaxQuery.add(numericRangeQuery);
        this.assertFieldNames(disjunctionMaxQuery, FieldType.NUMBER, "intField");
        this.assertFieldNames(disjunctionMaxQuery, FieldType.STRING, "stringField");
    }

    private void assertFieldNames(Query query, FieldType fieldType, String ... expectedFields) {
        FieldNameCollector.FieldCollection fieldCollection = FieldNameCollector.extractFieldNames(query);
        HashSet<String> actualFieldNames = new HashSet<String>();
        if (FieldType.STRING.equals((Object)fieldType)) {
            actualFieldNames.addAll(fieldCollection.getStringFieldNames());
        } else {
            actualFieldNames.addAll(fieldCollection.getNumericFieldNames());
        }
        for (String expectedFieldName : expectedFields) {
            if (!actualFieldNames.contains(expectedFieldName)) {
                Assert.fail((String)("The expected field name " + expectedFieldName + " was not found in the actual field names: " + actualFieldNames));
            }
            actualFieldNames.remove(expectedFieldName);
        }
        if (!actualFieldNames.isEmpty()) {
            Assert.fail((String)("There were field names which were unexpected: " + actualFieldNames));
        }
    }

    private void indexTestDocuments(Directory directory) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(TestConstants.getTargetLuceneVersion(), new StandardAnalyzer());
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        IndexWriter indexWriter = new IndexWriter(directory, indexWriterConfig);
        Document document = new Document();
        document.add(new StringField("stringField", "test", Field.Store.NO));
        document.add(new IntField("intField", 0, Field.Store.NO));
        indexWriter.addDocument(document);
        indexWriter.commit();
        indexWriter.close();
    }

    static enum FieldType {
        STRING,
        NUMBER;

    }
}

