/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.searchfactory;

import java.lang.annotation.ElementType;
import java.util.Set;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;

public class SearchFactoryTest {
    @Test
    public void testTypeWithNoDocumentIdThrowsException() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed();
        cfg.setProgrammaticMapping(mapping);
        try {
            new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator();
            Assert.fail((String)"Invalid configuration should have thrown an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("HSEARCH000177"));
        }
    }

    @Test
    public void testGetIndexedTypesNoTypeIndexed() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        try (SearchIntegrator si = new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator();){
            Set<Class<?>> indexedClasses = si.getIndexedTypes();
            Assert.assertEquals((String)"Wrong number of indexed entities", (long)0L, (long)indexedClasses.size());
        }
    }

    @Test
    public void testGetIndexedTypeSingleIndexedType() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        try (SearchIntegrator si = new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator();){
            Set<Class<?>> indexedClasses = si.getIndexedTypes();
            Assert.assertEquals((String)"Wrong number of indexed entities", (long)1L, (long)indexedClasses.size());
            Assert.assertTrue((boolean)indexedClasses.iterator().next().equals(Foo.class));
        }
    }

    @Test
    public void testGetIndexedTypesMultipleTypes() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId().entity(Bar.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        SearchIntegrator si = new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator();
        Set<Class<?>> indexedClasses = si.getIndexedTypes();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)2L, (long)indexedClasses.size());
    }

    @Test
    public void testGetTypeDescriptorForUnindexedType() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        try (SearchIntegrator si = new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator();){
            IndexedTypeDescriptor indexedTypeDescriptor = si.getIndexedTypeDescriptor(Foo.class);
            Assert.assertNotNull((Object)indexedTypeDescriptor);
            Assert.assertFalse((boolean)indexedTypeDescriptor.isIndexed());
        }
    }

    @Test
    public void testGetTypeDescriptorForIndexedType() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        try (SearchIntegrator si = new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator();){
            IndexedTypeDescriptor indexedTypeDescriptor = si.getIndexedTypeDescriptor(Foo.class);
            Assert.assertNotNull((Object)indexedTypeDescriptor);
            Assert.assertTrue((boolean)indexedTypeDescriptor.isIndexed());
        }
    }

    private SearchConfigurationForTest getManualConfiguration() {
        return new SearchConfigurationForTest().addClass(Foo.class).addClass(Bar.class);
    }

    public static class Bar {
        private long id;
    }

    public static class Foo {
        private long id;
    }
}

