/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.util.List;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionHelperTest {
    @Test
    public void testIsSearchAnnotation() throws Exception {
        AnnotationDescriptor descriptor = new AnnotationDescriptor(IndexedEmbedded.class);
        Object annotation = AnnotationFactory.create(descriptor);
        Assert.assertTrue((boolean)ReflectionHelper.isSearchAnnotation(annotation));
        descriptor = new AnnotationDescriptor(Override.class);
        annotation = AnnotationFactory.create(descriptor);
        Assert.assertFalse((boolean)ReflectionHelper.isSearchAnnotation(annotation));
    }

    @Test
    public void testIsSearchEnabled() throws Exception {
        JavaReflectionManager reflectionManager = new JavaReflectionManager();
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations(reflectionManager.toXClass(A.class)));
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations(reflectionManager.toXClass(B.class)));
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations(reflectionManager.toXClass(C.class)));
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations(reflectionManager.toXClass(D.class)));
        Assert.assertFalse((String)"Should not be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations(reflectionManager.toXClass(E.class)));
    }

    @Test
    public void testCreateInstanceWithClassHavingPrivateNoArgConstructorThrowsException() {
        try {
            ReflectionHelper.createInstance(F.class, false);
            Assert.fail((String)"It should not be possible to create a class with no public no-args constructor.");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000242"));
        }
    }

    @Test
    public void testCreateInstanceWithClassHavingNoNoArgConstructorThrowsException() {
        try {
            ReflectionHelper.createInstance(G.class, false);
            Assert.fail((String)"It should not be possible to create a class with no public no-args constructor.");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000242"));
        }
    }

    @Test
    public void testUsingMultipleFactoryAnnotationsThrowsException() {
        try {
            ReflectionHelper.createInstance(H.class, true);
            Assert.fail((String)"More than once @Factory annotation should throw an exception.");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000241"));
        }
    }

    @Test
    public void testFactoryMethodWithNoReturnTypeThrowsException() {
        try {
            ReflectionHelper.createInstance(I.class, true);
            Assert.fail((String)"Factory methods w/o return type should throw an exception.");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000244"));
        }
    }

    @Test
    public void testSuccessfulExecutionOfFactoryMethod() {
        Assert.assertTrue((String)"The factory method return type was expected.", (boolean)(ReflectionHelper.createInstance(K.class, true) instanceof D));
    }

    @Test
    public void testSuccessfulInstantiationOfClass() {
        Assert.assertTrue((String)"The factory method should not be executed", (boolean)(ReflectionHelper.createInstance(K.class, false) instanceof K));
    }

    public static class K {
        @Factory
        public D create() {
            return new D();
        }
    }

    public static class J {
        @Factory
        public Object foo() {
            throw new IllegalArgumentException();
        }
    }

    public static class I {
        @Factory
        public void foo() {
        }
    }

    public static class H {
        @Factory
        public Object foo() {
            return new Object();
        }

        @Factory
        public Object bar() {
            return new Object();
        }
    }

    public class G {
        private G(String foo) {
        }
    }

    public class F {
        private F() {
        }
    }

    public class E {
    }

    @Analyzer
    public static class D {
    }

    public class C {
        @FieldBridge
        public String getFoo() {
            return null;
        }
    }

    public class B {
        @IndexedEmbedded
        private List<A> aList;
    }

    public class A {
        @Field
        private String name;
    }
}

