/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.logging;

import java.util.List;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.hibernate.search.test.util.logging.TestAppender;
import org.hibernate.search.util.logging.impl.LoggerInfoStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class LoggerInfoStreamTest {
    private static final Version VERSION = Version.LUCENE_48;
    private Level hsearchLevel;
    private Logger hsearchLogger = Logger.getLogger((String)"org.hibernate.search");
    private Logger rootLogger = Logger.getRootLogger();
    private TestAppender testAppender;

    @Before
    public void setUp() throws Exception {
        this.testAppender = new TestAppender();
        this.rootLogger.addAppender((Appender)this.testAppender);
        this.hsearchLevel = this.hsearchLogger.getLevel();
        this.hsearchLogger.setLevel(Level.TRACE);
    }

    @After
    public void tearDown() throws Exception {
        this.rootLogger.removeAppender((Appender)this.testAppender);
        this.hsearchLogger.setLevel(this.hsearchLevel);
    }

    @Test
    public void testEnableInfoStream() throws Exception {
        LoggerInfoStream infoStream = new LoggerInfoStream();
        RAMDirectory directory = new RAMDirectory();
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(VERSION, new StandardAnalyzer(VERSION));
        indexWriterConfig.setInfoStream(infoStream);
        IndexWriter indexWriter = new IndexWriter(directory, indexWriterConfig);
        Document doc = new Document();
        doc.add(new StringField("f1", "value1", Field.Store.YES));
        indexWriter.addDocument(doc);
        indexWriter.commit();
        indexWriter.close();
        List<LoggingEvent> loggingEvents = this.testAppender.searchByLoggerAndMessage("org.hibernate.search.backend.lucene.infostream", "IW:");
        TestCase.assertFalse((boolean)loggingEvents.isEmpty());
    }
}

