/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.junit;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class SearchFactoryHolder
extends ExternalResource {
    private final SearchMapping buildMappingDefinition;
    private final Class<?>[] entities;
    private final Properties configuration;
    private final Map<Class<? extends Service>, Service> providedServices = new HashMap<Class<? extends Service>, Service>();
    private SearchIntegrator[] searchIntegrator;
    private int numberOfSessionFactories = 1;

    public SearchFactoryHolder(Class<?> ... entities) {
        this((SearchMapping)null, entities);
    }

    public SearchFactoryHolder(SearchMapping buildMappingDefinition, Class<?> ... entities) {
        this.buildMappingDefinition = buildMappingDefinition;
        this.entities = entities;
        this.configuration = new Properties();
    }

    public ExtendedSearchIntegrator getSearchFactory() {
        return this.searchIntegrator[0].unwrap(ExtendedSearchIntegrator.class);
    }

    protected void before() throws Throwable {
        this.searchIntegrator = new SearchIntegrator[this.numberOfSessionFactories];
        for (int i = 0; i < this.numberOfSessionFactories; ++i) {
            this.searchIntegrator[i] = this.createSearchFactory();
        }
    }

    private SearchIntegrator createSearchFactory() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setProgrammaticMapping(this.buildMappingDefinition);
        for (Map.Entry<Class<? extends Service>, Service> entry : this.providedServices.entrySet()) {
            cfg.addProvidedService(entry.getKey(), entry.getValue());
        }
        for (String key : this.configuration.stringPropertyNames()) {
            cfg.addProperty(key, this.configuration.getProperty(key));
        }
        for (Class<?> c : this.entities) {
            cfg.addClass(c);
        }
        return new SearchIntegratorBuilder().configuration(cfg).buildSearchIntegrator();
    }

    protected void after() {
        if (this.searchIntegrator != null) {
            for (SearchIntegrator sf : this.searchIntegrator) {
                sf.close();
            }
        }
    }

    public SearchFactoryHolder withProperty(String key, Object value) {
        Assert.assertNull((String)"SearchIntegrator already initialized", (Object)this.searchIntegrator);
        this.configuration.put(key, value);
        return this;
    }

    public <T extends Service> SearchFactoryHolder withService(Class<T> serviceType, T serviceInstance) {
        this.providedServices.put(serviceType, serviceInstance);
        return this;
    }

    public AbstractWorkspaceImpl extractWorkspace(Class indexedType) {
        EntityIndexBinding indexBindingForEntity = this.getSearchFactory().getIndexBinding(indexedType);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBindingForEntity.getIndexManagers()[0];
        LuceneBackendQueueProcessor backend = (LuceneBackendQueueProcessor)indexManager.getBackendQueueProcessor();
        return backend.getIndexResources().getWorkspace();
    }

    public SearchFactoryHolder multipleInstances(int clusterNodes) {
        if (clusterNodes < 1) {
            throw new SearchException("Can not construct less than one node");
        }
        this.numberOfSessionFactories = clusterNodes;
        return this;
    }
}

