/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.leakdetection;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMDirectory;

public class FileMonitoringDirectory
extends RAMDirectory {
    private final ConcurrentMap<IndexOutput, IndexOutput> openOutputs = new ConcurrentHashMap<IndexOutput, IndexOutput>(10);
    private final ConcurrentMap<IndexInput, IndexInput> openInputs = new ConcurrentHashMap<IndexInput, IndexInput>(40);

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        IndexOutput indexOutput = super.createOutput(name, context);
        IndexOutputDelegate tracked = new IndexOutputDelegate(indexOutput);
        this.openOutputs.put(tracked, tracked);
        return tracked;
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        IndexInput openInput = super.openInput(name, context);
        IndexInputDelegate tracked = new IndexInputDelegate(openInput);
        this.openInputs.put(tracked, tracked);
        return tracked;
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public boolean allFilesWereClosed() {
        return this.openInputs.isEmpty() && this.openOutputs.isEmpty();
    }

    private class IndexInputDelegate
    extends IndexInput {
        private final IndexInput delegate;

        public IndexInputDelegate(IndexInput delegate) {
            super(delegate.toString());
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            FileMonitoringDirectory.this.openInputs.remove(this);
        }

        @Override
        public String toString() {
            return "IndexInputDelegate to " + this.delegate.toString();
        }

        @Override
        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            this.delegate.readBytes(b, offset, len);
        }

        @Override
        public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
            this.delegate.readBytes(b, offset, len, useBuffer);
        }

        @Override
        public long getFilePointer() {
            return this.delegate.getFilePointer();
        }

        @Override
        public void seek(long pos) throws IOException {
            this.delegate.seek(pos);
        }

        @Override
        public long length() {
            return this.delegate.length();
        }

        @Override
        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        @Override
        public int readInt() throws IOException {
            return this.delegate.readInt();
        }

        @Override
        public int readVInt() throws IOException {
            return this.delegate.readVInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        @Override
        public long readVLong() throws IOException {
            return this.delegate.readVLong();
        }

        @Override
        public String readString() throws IOException {
            return this.delegate.readString();
        }

        @Override
        public Map<String, String> readStringStringMap() throws IOException {
            return this.delegate.readStringStringMap();
        }

        @Override
        public Set<String> readStringSet() throws IOException {
            return this.delegate.readStringSet();
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            return this.delegate.slice(sliceDescription, offset, length);
        }

        @Override
        public void skipBytes(long numBytes) throws IOException {
            this.delegate.skipBytes(numBytes);
        }

        @Override
        public IndexInput clone() {
            IndexInput clonedDelegate = this.delegate.clone();
            return new IndexInputDelegate(clonedDelegate);
        }
    }

    private class IndexOutputDelegate
    extends IndexOutput {
        private final IndexOutput delegate;

        public IndexOutputDelegate(IndexOutput delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return "IndexOutputDelegate to " + this.delegate.toString();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            FileMonitoringDirectory.this.openOutputs.remove(this);
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.delegate.writeByte(b);
        }

        @Override
        @Deprecated
        public void flush() throws IOException {
            throw new IllegalStateException("should never be called");
        }

        @Override
        public void writeBytes(byte[] b, int length) throws IOException {
            this.delegate.writeBytes(b, length);
        }

        @Override
        public long getFilePointer() {
            return this.delegate.getFilePointer();
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.delegate.writeBytes(b, offset, length);
        }

        @Override
        public long length() throws IOException {
            return this.delegate.length();
        }

        @Override
        public void writeInt(int i) throws IOException {
            this.delegate.writeInt(i);
        }

        @Override
        public void writeShort(short i) throws IOException {
            this.delegate.writeShort(i);
        }

        @Override
        public void writeLong(long i) throws IOException {
            this.delegate.writeLong(i);
        }

        @Override
        public void writeString(String s) throws IOException {
            this.delegate.writeString(s);
        }

        @Override
        public void copyBytes(DataInput input, long numBytes) throws IOException {
            this.delegate.copyBytes(input, numBytes);
        }

        @Override
        public void writeStringStringMap(Map<String, String> map) throws IOException {
            this.delegate.writeStringStringMap(map);
        }

        @Override
        public void writeStringSet(Set<String> set) throws IOException {
            this.delegate.writeStringSet(set);
        }

        @Override
        public long getChecksum() throws IOException {
            return this.delegate.getChecksum();
        }
    }
}

