/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.readerprovider;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.index.StoredFieldVisitor;
import org.hibernate.search.query.engine.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.readerprovider.FieldSelectorLeakingReaderProvider;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1738")
public class FieldSelectorTest {
    @Test
    public void testEagerStop() throws IOException {
        HashSet<String> acceptedFieldNames = new HashSet<String>();
        acceptedFieldNames.add("field one");
        acceptedFieldNames.add("field two");
        ReusableDocumentStoredFieldVisitor fieldVisitor = new ReusableDocumentStoredFieldVisitor(acceptedFieldNames);
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.NO), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("made up field one"))));
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.YES), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("field one"))));
        this.consumeField(fieldVisitor);
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.NO), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("made up field two"))));
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.NO), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("made up field three"))));
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.YES), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("field two"))));
        this.consumeField(fieldVisitor);
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.STOP), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("made up field four"))));
        fieldVisitor.getDocumentAndReset();
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.NO), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("made up field one"))));
        Assert.assertEquals((Object)((Object)StoredFieldVisitor.Status.YES), (Object)((Object)fieldVisitor.needsField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("field one"))));
    }

    private void consumeField(ReusableDocumentStoredFieldVisitor fieldVisitor) throws IOException {
        fieldVisitor.stringField(FieldSelectorLeakingReaderProvider.forgeFieldInfo("anything"), "anything");
    }
}

